//$Id: app-res.h,v 1.12 2002/01/01 21:23:39 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001-2002 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifndef GUIKACHU_APP_RES_H
#define GUIKACHU_APP_RES_H

namespace Guikachu
{
    namespace Resources
    {
	class Application;
    }
}

#include <iostream>
#include <sigc++/basic_signal.h>
#include <string>

#include "resource.h"

namespace Guikachu
{
    namespace GUI
    {
	class AppWindow; // Forward declaration
    }
    
    namespace Resources
    {
	class Application: public SigC::Object
	{
	    GUI::AppWindow *gui;

	    class VendorID: public Property<std::string>
	    {
	    public:
		VendorID (notify_signal_t   &notify_signal,
			  const std::string &value);
		
		inline const std::string& operator= (const std::string &value_) { set_val (value_); return value; };
		virtual void set_val (const std::string &value);
	    };
	    
	public:
	    Application ();
	    ~Application ();
	    SigC::Signal0<void> changed;

	    void show_ui ();

	    Property<std::string> iconname;
	    Property<std::string> version;
	    VendorID              vendor;
	    
	    void reset ();
	    
	public:
	    bool load (StorageNode &node);
	    void save (StorageNode &node) const;
	    void save_rcp (std::ostream &ostr) const;
	};

	std::ostream& operator<< (std::ostream &ostr, const Application* res);
    };
};

#endif /* !GUIKACHU_APP_RES_H */
