<?xml version="1.0"?> <!-- -*- xml -*- -->
<!--
 Guikachu Copyright (C) 2001-2002 RDI Gerg <cactus@cactus.rulez.org>
 
 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License version 2
 as published by the Free Software Foundation.
 
 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.
 
 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
-->

<xsl:stylesheet version="1.0"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

  <!-- Position and size -->
  <xsl:template match="form/widgets/*/pos">
    <xsl:text> AT (</xsl:text>
    
    <!-- Position -->
    <xsl:value-of select="@x"/>
    <xsl:text> </xsl:text>
    <xsl:value-of select="@y"/>
    
    <!-- Size -->
    <xsl:if test="@width">
      <xsl:text> </xsl:text>
      <xsl:value-of select="@width"/>
    </xsl:if>
    <xsl:if test="@height">
      <xsl:text> </xsl:text>
      <xsl:value-of select="@height"/>
    </xsl:if>
    <xsl:text>)</xsl:text>  
  </xsl:template>

  <xsl:template match="form/widgets/*/text">
    <xsl:text>"</xsl:text>
    <xsl:apply-templates/>
    <xsl:text>"</xsl:text>
  </xsl:template>

  <xsl:include href="button.xsl"/>
  <xsl:include href="label.xsl"/>
  <xsl:include href="graffiti.xsl"/>
  <xsl:include href="checkbox.xsl"/>
  <xsl:include href="pushbutton.xsl"/>
  <xsl:include href="popup-trigger.xsl"/>
  <xsl:include href="selector-trigger.xsl"/>
  <xsl:include href="list.xsl"/>
  <xsl:include href="scrollbar.xsl"/>
  <xsl:include href="text-field.xsl"/>
  <xsl:include href="table.xsl"/>
  <xsl:include href="gadget.xsl"/>
  
</xsl:stylesheet>
