//$Id: property.h,v 1.11 2002/01/01 21:23:39 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001-2002 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifndef GUIKACHU_PROPERTY_H
#define GUIKACHU_PROPERTY_H

#include <sigc++/basic_signal.h>
#include <string>
#include <iostream>

namespace Guikachu
{
    template <class T>
    class Property
    {
    protected:
	typedef T                   value_t;
	typedef Property<T>         self_t;
    
	typedef SigC::Signal0<void> notify_signal_t;

    public:
	notify_signal_t &changed;
	
    protected:
	value_t          value;
	
    public:
	Property (notify_signal_t &notify_signal,
		  const value_t   &value_ = 0):
	    changed (notify_signal),
	    value (value_)
	    {
	    };
	    
	virtual ~Property () {};

	virtual inline const value_t & get_val () const { return value; };
	virtual void set_val (const value_t &value_)
	    {
		if (value != value_)
		{
		    value = value_;
		    changed ();
		}
	    };
	
	inline const value_t& operator= (const value_t &value_) { set_val (value_); return value; };
	inline const value_t& operator= (const self_t  &other)  { set_val (other.value); return value; };
	inline operator value_t () const { return get_val (); };
	inline value_t operator() () const { return get_val (); };

	inline bool operator== (const value_t &other) const { return value == other; };
	inline bool operator== (const self_t  &other) const { return value == other.value; };
	
	inline bool operator!= (const value_t &other) const { return value != other; };
	inline bool operator!= (const self_t  &other) const { return value != other.value; };

	inline value_t operator+= (const value_t &other) { set_val (value + other); return value; };
	inline value_t operator+= (const self_t  &other) { set_val (value + other.value); return value; };

	inline value_t operator-= (const value_t &other) { set_val (value - other); return value; };
	inline value_t operator-= (const self_t  &other) { set_val (value - other.value); return value; };
	
	friend std::ostream & operator<<<value_t> (std::ostream &ostr, const Property<value_t> &prop);
    };

    template<class T>
    inline std::ostream & operator<< (std::ostream &ostr, const Property<T> &prop)
    {
	ostr << prop.value;
	return ostr;
    }

    class ID: public Property<std::string>
    {
    public:
	ID (notify_signal_t   &notify_signal,
	    const std::string &value);
	
	inline const std::string& operator= (const std::string &value_) { set_val (value_); return value; };
	virtual void set_val (const std::string &value);
    };
}

#endif /* !GUIKACHU_PROPERTY_H */
