//$Id: gadget.h,v 1.6 2002/03/15 17:47:08 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001-2002 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifndef GUIKACHU_FORM_EDITOR_GADGET_H
#define GUIKACHU_FORM_EDITOR_GADGET_H

namespace Guikachu
{
    namespace Widgets
    {
	class Gadget;
    }
}

#include "widget.h"
#include "resizeable-widget.h"

#include "gadget-prop.h"

namespace Guikachu
{
    namespace Widgets
    {
	class Gadget: public Widget,
		      public ResizeableWidget
	{
	    GUI::FormEditor::GadgetProperties *editor;
	    
	public:
	    Gadget (Resources::Form   *owner,
		    const std::string &id);
	    virtual ~Gadget ();
	    
	    virtual Type get_type () const { return WIDGET_GADGET; };
	    
	    virtual Gtk::Widget                       *create_editor ();
	    virtual GUI::FormEditor::WidgetCanvasItem *create_canvas_item (Gnome::CanvasGroup *parent_group);

	    Property<bool> usable;
	    
	private:
	    // Persistance
	    virtual bool load (StorageNode &node);
	    virtual void save (StorageNode &node) const;
	    virtual void save_rcp (std::ostream &ostr) const;
	};
    }
}

#endif /* !GUIKACHU_FORM_EDITOR_GADGET_H */
