<?xml version="1.0"?> <!-- -*- xml -*- -->
<!--
 Guikachu Copyright (C) 2001-2002 RDI Gerg <cactus@cactus.rulez.org>
 
 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License version 2
 as published by the Free Software Foundation.
 
 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.
 
 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
-->

<xsl:stylesheet version="1.0"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

  <!-- Position and size -->
  <xsl:template match="form/pos">
    <xsl:text>AT (</xsl:text>
    
    <!-- Position -->
    <xsl:value-of select="@x"/>
    <xsl:text> </xsl:text>
    <xsl:value-of select="@y"/>
    
    <!-- Size -->
    <xsl:text> </xsl:text>
    <xsl:value-of select="@width"/>
    <xsl:text> </xsl:text>
    <xsl:value-of select="@height"/>
    <xsl:text>)</xsl:text>  
  </xsl:template>
  
  <!-- A form -->
  <xsl:template match="form">
    <xsl:text>FORM ID </xsl:text>
    <xsl:value-of select="@id"/>
    <xsl:text>
</xsl:text>

    <xsl:apply-templates select="pos"/>
    <xsl:text>
</xsl:text>

    <!-- Flags -->
    <xsl:text>USABLE </xsl:text>
    
    <xsl:choose>
      <xsl:when test="savebehind">
	<xsl:text>SAVEBEHIND </xsl:text>
      </xsl:when>
      <xsl:otherwise>
	<xsl:text>NOSAVEBEHIND </xsl:text>
      </xsl:otherwise>
    </xsl:choose>

    <xsl:choose>
      <xsl:when test="frame">
	<xsl:text>FRAME </xsl:text>
      </xsl:when>
      <xsl:otherwise>
	<xsl:text>NOFRAME </xsl:text>
      </xsl:otherwise>
    </xsl:choose>

    <xsl:if test="modal">
      <xsl:text>MODAL</xsl:text>
    </xsl:if>

    <xsl:text>
</xsl:text>

    <!-- Form menu -->
    <xsl:if test="menu">
      <xsl:text>MENUID </xsl:text>
      <xsl:value-of select="menu/@id"/>
      <xsl:text>
</xsl:text>
    </xsl:if>

    <!-- Default button -->
    <xsl:if test="widgets/@default">
      <xsl:text>DEFAULTBTNID </xsl:text>
      <xsl:value-of select="widgets/@default"/>
      <xsl:text>
</xsl:text>
    </xsl:if>

    <!-- Widgets -->
    <xsl:text>BEGIN</xsl:text>
    <xsl:text>
</xsl:text>
    <xsl:if test="title">
      <xsl:text>  TITLE "</xsl:text>
      <xsl:value-of select="title"/>
      <xsl:text>"
</xsl:text>
    </xsl:if>
    <xsl:apply-templates select="widgets"/>
    <xsl:text>END</xsl:text>
    
    <xsl:text>

</xsl:text>
  </xsl:template>

  <xsl:include href="widgets.xsl"/>

</xsl:stylesheet>
