//$Id: stringlist-res.cc,v 1.2 2002/01/01 21:23:39 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001-2002 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include "stringlist-res.h"
#include "stringlist-win.h"

using namespace Guikachu;
using std::string;

Resources::StringList::StringList (const string &id):
    Resource (id),
    gui (0),
    prefix (changed, ""),
    strings (changed, std::vector<std::string>())
{
}

Resources::StringList::~StringList ()
{
    delete gui;
}

void Resources::StringList::show_ui ()
{
    if (!gui)
	gui = new GUI::StringListWindow (this);

    gui->show ();
}

void Resources::StringList::save (StorageNode &node) const
{
    node.add_node ("prefix", prefix);
    
    const std::vector<std::string> &strings_tmp = strings;
    for (std::vector<std::string>::const_iterator i = strings_tmp.begin ();
	 i != strings_tmp.end (); i++)
	node.add_node ("text", *i);
}

bool Resources::StringList::load (StorageNode &node)
{
    StorageNode curr_node;
    std::vector<std::string> strings_tmp;
    
    for (curr_node  = node.children ();
	 curr_node; curr_node  = curr_node.next ())
    {
	if (curr_node.name () == "text")
	    strings_tmp.push_back (curr_node.get_content ());
	else if (curr_node.name () == "prefix")
	    prefix = curr_node.get_content ();
	else
	    g_warning ("Error parsing `stringlist' resource: "
		       "unexpected element `%s'", curr_node.name ().c_str ());
    }

    strings = strings_tmp;
    changed ();
    
    return true;
}

void Resources::StringList::save_rcp (std::ostream &ostr) const
{
    ostr << "STRINGTABLE ID " << id
	 << " \"" << prefix << "\"" << std::endl;

    ostr << " ";
    const std::vector<std::string> &strings_tmp = strings;
    for (std::vector<std::string>::const_iterator i = strings_tmp.begin ();
	 i != strings_tmp.end (); i++)
	ostr << " \"" << *i << "\"";
    
    ostr << std::endl
	 << std::endl;
}
