//$Id: form-win-selection.cc,v 1.1 2002/02/16 17:15:10 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001-2002 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include "form-win.h"

using namespace Guikachu::GUI;

void FormWindow::selection_add (Widget *widget)
{
    selected_widgets.insert (widget);
    widget->selected (true);
}

void FormWindow::selection_remove (Widget *widget)
{
#if 0
    if (selected_widgets.find (widget) == selected_widgets.end ())
	return;
#endif
    
    selected_widgets.erase (widget);
    widget->selected (false);

    if (last_widget == widget)
    {
	last_widget->selected_last (false);
	last_widget = 0;
    }
}

void FormWindow::selection_toggle (Widget *widget)
{
    if (selected_widgets.find (widget) == selected_widgets.end ())
	selection_add (widget);
    else
	selection_remove (widget);
}

void FormWindow::selection_clear ()
{
    for (std::set<Widget*>::iterator i = selected_widgets.begin ();
	 i != selected_widgets.end (); i++)
	(*i)->selected (false);

    if (selected_widgets.find (last_widget) != selected_widgets.end ())
    {
	last_widget->selected_last (false);
	last_widget = 0;
    }
    
    selected_widgets.clear ();
}

void FormWindow::select_form ()
{
    bool add_to_selection;
    
    {
	GdkModifierType modifiers;
	int dummy;
	
	canvas->get_window ().get_pointer (dummy, dummy, modifiers);
	add_to_selection = modifiers & GDK_CONTROL_MASK;
    }

    if (add_to_selection)
	return;

    selection_clear ();
    
    form_widget->selected (true);
    top_treeitem->select ();
   
    show_form_property_editor ();
}

void FormWindow::widget_selected_last_cb (Widget *widget, bool selected)
{
    if (!selected)
	return;
    
}

void FormWindow::select_widget (Widget *widget)
{
    bool add_to_selection;
    
    {
	GdkModifierType modifiers;
	int dummy;
	
	canvas->get_window ().get_pointer (dummy, dummy, modifiers);
	add_to_selection = modifiers & GDK_CONTROL_MASK;
    }

    top_treeitem->deselect ();
    form_canvas_item->selected (false);
    widget->request_edit ();
    
    if (!add_to_selection)
    {
	if (selected_widgets.find (widget) == selected_widgets.end ())
	    selection_clear ();
	selection_add (widget);
    } else {
	selection_toggle (widget);
    }
}

void FormWindow::selection_box_cb (int x1, int y1,
				   int x2, int y2)
{
    x1 -= res->x;
    x2 -= res->x;

    y1 -= res->y;
    y2 -= res->y;
    
    bool add_to_selection;
    
    {
	GdkModifierType modifiers;
	int dummy;
	
	canvas->get_window ().get_pointer (dummy, dummy, modifiers);
	add_to_selection = modifiers & GDK_CONTROL_MASK;
    }

    if (!add_to_selection)
	selection_clear ();

    const std::set<Widget*>& widgets = res->get_widgets ();
    for (std::set<Widget*>::const_iterator i = widgets.begin ();
	 i != widgets.end (); i++)
    {
	FormEditor::WidgetCanvasItem *canvas_item =
	    (*i)->get_canvas_item (form_canvas_item->get_widget_group ());
	
	if (canvas_item->is_within (x1, y1, x2, y2))
	    selection_add (*i);
    }
}
