//$Id: font.h,v 1.7 2002/01/12 14:12:03 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001-2002 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifndef GUIKACHU_FORM_EDITOR_FONT_H
#define GUIKACHU_FORM_EDITOR_FONT_H

#include <string>
#include <iostream>
#include "hash-map.h"

#include <gdk-pixbuf/gdk-pixbuf.h>
#include <gdk--/color.h>

namespace Guikachu
{
    namespace GUI
    {
	namespace FormEditor
	{
	    struct Glyph
	    {
		unsigned int   width;
		int            offset;
		bool         **bitmap;
	    public:
		Glyph (std::istream &stream, unsigned int &height);
		Glyph (unsigned int height, unsigned int ascent); // Create placeholder glyph
	    };
	    
	    class Font
	    {
		std::hash_map <char, Glyph> glyphs;
		unsigned int                height, ascent, descent;
		
	    public:
		Font (const std::string &filename);
		Font ();

		void parse (const std::string &filename);
		void parse (std::istream      &stream);

		GdkPixbuf* render (const std::string &text,
				   const Gdk_Color   &color) const;

		unsigned int string_width (const std::string& text) const;
		
		int get_height  () const { return height; };
		int get_ascent  () const { return ascent; };
		int get_descent () const { return descent; };

	    private:
		const Glyph& get_glyph (char c) const;
	    };
	}
    }
}

#endif /* !GUIKACHU_FORM_EDITOR_FONT_H */
