<?xml version="1.0"?> <!-- -*- xml -*- -->
<!--
 Guikachu Copyright (C) 2001-2002 RDI Gerg <cactus@cactus.rulez.org>
 
 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License version 2
 as published by the Free Software Foundation.
 
 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.
 
 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
-->

<xsl:stylesheet version="1.0"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

  <xsl:template match="form/widgets/scrollbar/pos">
    <xsl:text> AT (</xsl:text>
    
    <!-- Position -->
    <xsl:value-of select="@x"/>
    <xsl:text> </xsl:text>
    <xsl:value-of select="@y"/>
    
    <!-- Size -->
    <xsl:choose>
      <xsl:when test="@width='auto'">
	<xsl:text> 7</xsl:text>
      </xsl:when>
      <xsl:otherwise>
	<xsl:text> </xsl:text>
	<xsl:value-of select="@width"/>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:text> </xsl:text>
    <xsl:value-of select="@height"/>   
    <xsl:text>)</xsl:text>
    
  </xsl:template>
  
  <xsl:template match="form/widgets/scrollbar/values">
    <xsl:if test="@value">
      <xsl:text> VALUE </xsl:text>
      <xsl:value-of select="@value"/>
    </xsl:if>

    <xsl:if test="@min">
      <xsl:text> MIN </xsl:text>
      <xsl:value-of select="@min"/>
    </xsl:if>

    <xsl:if test="@max">
      <xsl:text> MAX </xsl:text>
      <xsl:value-of select="@max"/>
    </xsl:if>
    
    <xsl:if test="@page_size">
      <xsl:text> PAGESIZE </xsl:text>
      <xsl:value-of select="@page_size"/>
    </xsl:if>
    <xsl:text> </xsl:text>
  </xsl:template>
  
  <xsl:template match="form/widgets/scrollbar">

    <xsl:text>  SCROLLBAR</xsl:text>

    <xsl:text> ID </xsl:text>
    <xsl:value-of select="@id"/>

    <xsl:apply-templates select="pos"/>

    <xsl:choose>
      <xsl:when test="usable">
	<xsl:text> USABLE</xsl:text>
      </xsl:when>
      <xsl:otherwise>
	<xsl:text> NONUSABLE</xsl:text>
      </xsl:otherwise>
    </xsl:choose>

    <xsl:apply-templates select="values"/>
    
    <xsl:text>
</xsl:text>
  </xsl:template>

</xsl:stylesheet>
