//$Id: size-entry.cc,v 1.6 2002/01/01 21:23:42 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001-2002 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include "widgets/size-entry.h"
#include "form-editor/form-editor.h"
#include "resource-manager.h"
#include "target.h"

using namespace Guikachu::GUI::PropertyEditors;

WidthEntry::WidthEntry (Property<int> &property):
    NumEntry (1, GUIKACHU_SCREEN_WIDTH, property)
{
    ResourceManager::get_target ()->changed.connect (
	SigC::slot (this, &WidthEntry::target_changed_cb));
}

void WidthEntry::target_changed_cb ()
{
    get_adjustment ()->set_upper (GUIKACHU_SCREEN_WIDTH);
}

HeightEntry::HeightEntry (Property<int> &property):
    NumEntry (1, GUIKACHU_SCREEN_HEIGHT, property)
{
    ResourceManager::get_target ()->changed.connect (
	SigC::slot (this, &HeightEntry::target_changed_cb));
}

void HeightEntry::target_changed_cb ()
{
    get_adjustment ()->set_upper (GUIKACHU_SCREEN_HEIGHT);
}

