//$Id: scrollbar.cc,v 1.16 2002/01/30 17:33:10 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001-2002 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include "scrollbar.h"
#include "scrollbar-canvas.h"

#include "form-editor.h"

#include <gnome-xml/xmlmemory.h>

using Guikachu::Widgets::ScrollBar;
using namespace Guikachu::GUI::FormEditor;

ScrollBar::ScrollBar (Resources::Form   *owner,
		      const std::string &id):
    Widget (owner, id),
    Resizeable (changed),
    AutoWidth (changed),
    
    editor (0),
    usable (changed, true),
    min_value (changed, 0),
    max_value (changed, 0),
    value (changed, 0),
    page_size (changed, 0)
{
    height = 40;
    
    changed.connect (SigC::slot (this, &ScrollBar::update));
}

ScrollBar::~ScrollBar ()
{
    if (editor)
	delete editor;
}

void ScrollBar::update ()
{
    static bool update_block = false;

    if (update_block)
	return;

    update_block = true;
    
    if (max_value < min_value)
	max_value = min_value;

    if (value < min_value)
	value = min_value;

    if (value > max_value)
	value = max_value;

    update_block = false;
}

Gtk::Widget* ScrollBar::create_editor ()
{
    if (!editor)
	editor = new ScrollBarProperties (this);

    return editor->get_editor ();
}

WidgetCanvasItem* ScrollBar::create_canvas_item (Gnome::CanvasGroup *parent_group)
{
    return new ScrollBarCanvasItem (this, parent_group);
}

bool ScrollBar::load (StorageNode &node)
{
    /* Non-NULL default values */
    usable = false;
    
    for (StorageNode curr_node  = node.children ();
	 curr_node; curr_node++)
    {
	if (curr_node.name () == "pos")
	{
	    x = curr_node.get_prop<int> ("x");
	    y = curr_node.get_prop<int> ("y");
	    
	    std::string width_str = curr_node.get_prop<std::string> ("width");
	    if (width_str == "auto")
	    {
		manual_width = false;
		width = 0;
	    } else {
		manual_width = true;
		width = atoi (width_str.c_str ());
	    }

	    /* Compatibility for pre-1.0 Guikachu files */
	    std::string height_str = curr_node.get_prop<std::string> ("height");
	    if (height_str == "auto")
		height = 100;
	    else
		height = atoi (height_str.c_str ());
	}
	else if (curr_node.name () == "usable")
	    usable = true;
	else if (curr_node.name () == "values")
	{
	    min_value = curr_node.get_prop<int> ("min");
	    max_value = curr_node.get_prop<int> ("max");
	    page_size = curr_node.get_prop<int> ("page_size");
	    value     = curr_node.get_prop<int> ("value");
	}
	else
	    g_warning ("Error parsing `scrollbar' widget: "
		       "unexpected element `%s'",
		       curr_node.name ().c_str ());
	}
    
    changed ();

    return true;
}

void ScrollBar::save (StorageNode &node) const
{
    StorageNode my_node;

    /* Position */
    my_node = node.add_node ("pos");
    my_node.set_prop ("x", x);
    my_node.set_prop ("y", y);

    /* Size */
    if (manual_width)
	my_node.set_prop ("width", width);
    else
	my_node.set_prop ("width", "auto");

    my_node.set_prop ("height", height);
    
    /* Usable */
    if (usable)
	node.add_node ("usable");

    /* Values */
    my_node = node.add_node ("values");
    my_node.set_prop ("min",       min_value);
    my_node.set_prop ("max",       max_value);
    my_node.set_prop ("page_size", page_size);
    my_node.set_prop ("value",     value);
}

void ScrollBar::save_rcp (std::ostream &ostr) const
{
    gchar *width_str, *height_str;

    width_str = g_strdup_printf ("%d", get_display_width ());
    height_str = g_strdup_printf ("%d", height ());

    ostr << "  SCROLLBAR ID " << id;
    ostr << " AT (" << x << " " << y << " " << width_str << " " << height_str << ")";

    ostr << " VALUE "    << value
	 << " MIN "      << min_value
	 << " MAX "      << max_value
	 << " PAGESIZE " << page_size;
    ostr << std::endl;
    
    g_free (height_str);
    g_free (width_str);
}

int ScrollBar::get_auto_width () const
{
    return 7; /* recommended width for scroll bars */
}
