<?xml version="1.0"?> <!-- -*- xml -*- -->
<!--
 Guikachu Copyright (C) 2001-2002 RDI Gerg <cactus@cactus.rulez.org>
 
 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License version 2
 as published by the Free Software Foundation.
 
 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.
 
 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
-->

<xsl:stylesheet version="1.0"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

  <!-- A dialog box -->
  <xsl:template match="dialog">

    <xsl:text>ALERT ID </xsl:text>
    <xsl:value-of select="@id"/>
    <xsl:text>
</xsl:text>

    <xsl:choose>
      <xsl:when test="string(type/@value)='information'">
	<xsl:text>INFORMATION</xsl:text>
      </xsl:when>
      <xsl:when test="string(type/@value)='confirmation'">
	<xsl:text>CONFIRMATION</xsl:text>
      </xsl:when>
      <xsl:when test="string(type/@value)='warning'">
	<xsl:text>WARNING</xsl:text>
      </xsl:when>
      <xsl:when test="string(type/@value)='error'">
	<xsl:text>ERROR</xsl:text>
      </xsl:when>
    </xsl:choose>
    <xsl:text>
</xsl:text>

    <xsl:if test="help/@id">
      <xsl:text>HELPID </xsl:text>
      <xsl:value-of select="help/@id"/>
      <xsl:text>
</xsl:text>	
    </xsl:if>

    <xsl:text>BEGIN
</xsl:text>

    <xsl:if test="title/text()">
      <xsl:text>TITLE "</xsl:text>
      <xsl:value-of select="title"/>
      <xsl:text>"
</xsl:text>
    </xsl:if>

    <xsl:if test="text/text()">
      <xsl:text>MESSAGE "</xsl:text>
      <xsl:value-of select="text"/>
      <xsl:text>"
</xsl:text>
    </xsl:if>

    <xsl:if test="buttons">
      <xsl:text>BUTTONS </xsl:text>
      <xsl:for-each select="buttons/button">
	<xsl:text>"</xsl:text>
	<xsl:value-of select="@label"/>
	<xsl:text>" </xsl:text>
      </xsl:for-each>
      
      <xsl:text>
</xsl:text>
    </xsl:if>

    <xsl:text>END
</xsl:text>
      
    <xsl:text>

</xsl:text>
    
  </xsl:template>
  
</xsl:stylesheet>
