//$Id: pushbutton.h,v 1.13 2002/01/01 21:23:40 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001-2002 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifndef GUIKACHU_FORM_EDITOR_PUSHBUTTON_H
#define GUIKACHU_FORM_EDITOR_PUSHBUTTON_H

namespace Guikachu
{
    namespace Widgets
    {
	class PushButton;
    }
}

#include "widget.h"
#include "resizeable.h"
#include "textual.h"

#include "pushbutton-prop.h"

namespace Guikachu
{
    namespace Widgets
    {
	class PushButton: public Widget,
			  public Resizeable,
			  public Textual
	{
	    GUI::FormEditor::PushButtonProperties *editor;
	    
	public:
	    PushButton (Resources::Form   *owner,
			const std::string &id);
	    virtual ~PushButton ();
	    
	    virtual Type get_type () const { return WIDGET_PUSHBUTTON; };
	    
	    virtual Gtk::Widget                       *create_editor ();
	    virtual GUI::FormEditor::WidgetCanvasItem *create_canvas_item (Gnome::CanvasGroup *parent_group);

	    Property<bool>   usable;
	    Property<int>    group;

	protected:
	    virtual int get_auto_width  () const;
	    virtual int get_auto_height () const;

	private:
	    // Persistance
	    virtual bool load (StorageNode &node);
	    virtual void save (StorageNode &node) const;
	    virtual void save_rcp (std::ostream &ostr) const;
	};
    }
}

#endif /* !GUIKACHU_FORM_EDITOR_PUSHBUTTON_H */
