//$Id: dialog-res.h,v 1.12 2002/01/01 21:23:39 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001-2002 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifndef GUIKACHU_DIALOG_RES_H
#define GUIKACHU_DIALOG_RES_H

namespace Guikachu
{
    namespace Resources
    {
	class Dialog;

	enum DialogType
	{
	    DIALOG_INFORMATION,
	    DIALOG_CONFIRMATION,
	    DIALOG_WARNING,
	    DIALOG_ERROR
	};
	    
    }
}

#include "resource.h"
#include "resource-ref.h"

#include <vector>

namespace Guikachu
{
    namespace GUI
    {
	class DialogWindow;
    }
    
    namespace Resources
    {
	class Dialog: public Resource
	{
	    Guikachu::GUI::DialogWindow *gui;
	public:
	    Dialog (const std::string& id);
	    virtual ~Dialog ();
	    
	    virtual Type get_type () const { return RESOURCE_DIALOG; };
	    virtual void show_ui ();

	    Property<std::string>               title;
	    Property<std::string>               text;
	    Property<DialogType>                dialog_type;
	    Property<std::vector<std::string> > buttons;
	    Property<unsigned int>              default_button;
	    Properties::ResourceRef             help_id;
	    
	private:
	    virtual bool load (StorageNode &node);
	    virtual void save (StorageNode &node) const;
	    virtual void save_rcp (std::ostream &ostr) const;
	};
    };
};

#endif /* !GUIKACHU_DIALOG_RES_H */
