//$Id: app-res.cc,v 1.15 2002/01/01 21:23:39 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001-2002 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include "app-res.h"
#include "app-win.h"

#include "config.h"
#include <libgnome/libgnome.h>

#include "mainwin.h"

using namespace Guikachu;
using std::string;
using std::ostream;

Resources::Application::VendorID::VendorID (notify_signal_t &notify_signal,
					    const string    &value):
    Property<string> (notify_signal, value)
{
}

void Resources::Application::VendorID::set_val (const string& value_)
{
    if (value_.length () == 0 || value_.length () == 4)
	Property<string>::set_val (value_);
    else {
	GUI::show_error (_("The vendor ID must be exactly "
			   "four characters long, or empty"));
    }
}

Resources::Application::Application ():
    gui (0),
    iconname (changed, ""),
    version (changed, ""),
    vendor (changed, "")
{
}

Resources::Application::~Application ()
{
    delete gui;
}

void Resources::Application::reset ()
{
    iconname = "";
    version = "";
    vendor = "";

    if (gui)
	gui->hide ();

    changed ();
}

void Resources::Application::show_ui ()
{
    if (!gui)
	gui = new GUI::AppWindow (this);

    gui->show ();
}

bool Resources::Application::load (StorageNode &node)
{
    StorageNode curr_node;

    iconname = "";
    version =  "";
    vendor =   "";
    
    for (curr_node  = node.children ();
	 curr_node; curr_node  = curr_node.next ())
    {
	if (curr_node.name () == "iconname")
	    iconname = curr_node.get_content ();
	else if (curr_node.name () == "version")
	    version = curr_node.get_content ();
	else if (curr_node.name () == "vendor")
	    vendor = curr_node.get_content ();
	else
	    g_warning ("Error parsing `application' resource: "
		       "unexpected element `%s'", curr_node.name ().c_str ());
    }

    changed ();
    return true;
}

void Resources::Application::save (StorageNode &node) const
{
    if (iconname != "")
	node.add_node ("iconname", iconname);
    if (version != "")
	node.add_node ("version",  version);
    if (vendor != "")
	node.add_node ("vendor",   vendor);
}

void Resources::Application::save_rcp (std::ostream &ostr) const
{
    if (version != "")
	ostr << "VERSION ID 1 \"" << version << "\"" << std::endl;
    if (iconname != "")
	ostr << "APPLICATIONICONNAME ID 1 \"" << iconname << "\"" << std::endl;
    if (vendor != "")
	ostr << "APPLICATION ID 1 \"" << vendor << "\"" << std::endl;
    ostr << std::endl;
}

std::ostream& Resources::operator<< (ostream &ostr, const Application *res)
{
    res->save_rcp (ostr);
    return ostr;
}
