//$Id: target.h,v 1.3 2002/01/01 21:23:39 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001-2002 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifndef GUIKACHU_TARGET_H
#define GUIKACHU_TARGET_H

#include <string>
#include <map>
#include <sigc++/object.h>

#include "property.h"
#include "storage-node.h"

namespace Guikachu
{
    class Target: public SigC::Object
    {
	std::string stock_id;

    public:
	Target ();
	
	void        load_stock   (const std::string &stock_id);
	std::string get_stock_id () const;

	static std::map<std::string, std::string> stock_targets ();
	static std::string get_default_stock_id ();
	
	SigC::Signal0<void> changed;
	
	// Screen dimensions in pixels (used by the form editor
	Property<int> screen_width;
	Property<int> screen_height;

	// Persistance
	bool load (StorageNode &node);
	void save (StorageNode &node) const;

    private:
	void changed_cb ();
    };
}    

#endif /* !GUIKACHU_TARGET_H */
