//$Id: storage-node.cc,v 1.8 2002/01/01 21:23:39 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001-2002 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include "storage-node.h"

#include "property.h"

#include <gnome-xml/xmlmemory.h>
#include <glib.h>
#include <libgnome/libgnome.h>

using namespace Guikachu;
using std::string;

StorageNode::StorageNode ():
    node_ptr (0)
{
}

StorageNode::StorageNode (xmlNodePtr root):
    node_ptr (root)
{   
}

StorageNode StorageNode::add_node (const string &name,
				   const string &content = "")
{
    g_return_val_if_fail (node_ptr != 0, 0);
    
    xmlNodePtr new_node_ptr = 0;

    if (content != "")
	new_node_ptr = xmlNewChild (node_ptr, 0,
				    (xmlChar*)name.c_str (),
				    (xmlChar*)content.c_str ());
    else
	new_node_ptr = xmlNewChild (node_ptr, 0,
				    (xmlChar*)name.c_str (), 0);

    return StorageNode (new_node_ptr);
}

void StorageNode::set_content (const string &content)
{
    g_return_if_fail (node_ptr != 0);

    xmlNodeSetContent (node_ptr, (xmlChar*) content.c_str ());
}

string StorageNode::get_content () const
{
    g_return_val_if_fail (node_ptr != 0, 0);

    string ret;
    char *text = (char*)xmlNodeGetContent (node_ptr);
    
    if (text)
    {
	ret = text;
	xmlFree (text);
    } else {
	ret = "";
    }

    return ret;
}


void StorageNode::set_prop (const string &prop_name,
			    const string &value)
{
    g_return_if_fail (node_ptr != 0);

    xmlSetProp (node_ptr,
		(xmlChar*) prop_name.c_str (),
		(xmlChar*) value.c_str ());
}

void StorageNode::set_prop (const string &prop_name,
			    unsigned int  value)
{
    g_return_if_fail (node_ptr != 0);

    char *tmp = g_strdup_printf ("%d", value);
    set_prop (prop_name, tmp);
    g_free (tmp);
}

void StorageNode::set_prop (const string &prop_name,
			    int           value)
{
    g_return_if_fail (node_ptr != 0);

    char *tmp = g_strdup_printf ("%d", value);
    set_prop (prop_name, tmp);
    g_free (tmp);
}

void StorageNode::set_prop (const string &prop_name,
			    char          value)
{
    g_return_if_fail (node_ptr != 0);

    if (!value)
	return;
    
    static char *buffer = g_new0 (char, 2);

    buffer[0] = value;
    set_prop (prop_name, buffer);
}

template <>
string StorageNode::get_prop <string> (const string &prop_name) const
{
    g_return_val_if_fail (node_ptr != 0, 0);

    string ret;
    
    xmlChar *xml_tmp = xmlGetProp (node_ptr, (xmlChar*) prop_name.c_str ());

    if (xml_tmp)
    {
	ret = (char*) xml_tmp;
	xmlFree (xml_tmp);
    } else {
	ret = "";
    }

    return ret;
}

template <>
int StorageNode::get_prop <int> (const string &prop_name) const
{
    g_return_val_if_fail (node_ptr != 0, 0);

    int ret;

    xmlChar *xml_tmp = xmlGetProp (node_ptr, (xmlChar*) prop_name.c_str ());
    if (xml_tmp)
    {
	ret = atoi ((char*) xml_tmp);
	xmlFree (xml_tmp);
    } else {
	ret = 0;
    }

    return ret;
}

template <>
char StorageNode::get_prop <char> (const string &prop_name) const
{
    g_return_val_if_fail (node_ptr != 0, 0);

    char ret = 0;

    xmlChar *xml_tmp = xmlGetProp (node_ptr, (xmlChar*) prop_name.c_str ());
    if (xml_tmp)
    {
	if (strlen ((char*) xml_tmp))
	    ret = (char) xml_tmp[0];
	
	xmlFree (xml_tmp);
    }

    return ret;
}

// Keep the definition of this below get_prop<std::string>'s
StorageNode StorageNode::next () const
{
#if 0
    // Get list of requested languages
    GList *lang_list = gnome_i18n_get_language_list ("LC_MESSAGES");

    if (!node_ptr->next)
	return StorageNode (0);
	
    StorageNode next_candidate (node_ptr->next);
    std::string next_lang = next_candidate.get_prop<std::string>("xml:lang");
    if (next_lang == "")
	next_lang = "C";

    printf ("Next tag's lang: %s\n", next_lang.c_str ());
    
//    std::string current_locale = 
    
    return next_candidate;
#else
    return node_ptr->next;
#endif
}

