//$Id: resource.h,v 1.19 2002/01/01 21:23:39 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001-2002 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifndef GUIKACHU_RESOURCE_H
#define GUIKACHU_RESOURCE_H

#include <string>
#include <iostream>
#include <sigc++/basic_signal.h>

namespace Guikachu
{
    namespace Resources
    {
	enum Type
	{
	    RESOURCE_DIALOG,
	    RESOURCE_STRING,
	    RESOURCE_STRINGLIST,
	    RESOURCE_MENU,
	    RESOURCE_FORM,
	    RESOURCE_BLOB
	};
    }
    
    class Resource;
}

#include "property.h"
#include "storage-node.h"
#include "resource-manager.h"

namespace Guikachu
{
    class Resource: public SigC::Object
    {
    protected:
	Resource (const std::string& id);
	
    public:
	virtual ~Resource () {};
	
	// Resource managment functions
	virtual Resources::Type get_type () const = 0;
	
	// Notification
	SigC::Signal0<void> changed;
	
	// Common properties
	ID id;
	
	// User interface hook
	virtual void show_ui () = 0;
	
    public:
	// Persistance
	virtual bool load (StorageNode &node) = 0;
	virtual void save (StorageNode &node) const = 0;
	virtual void save_rcp (std::ostream &ostr) const = 0;
	};
    
    std::ostream& operator<< (std::ostream &ostr, const Resource* res);
}

#endif /* !GUIKACHU_RESOURCE_H */
