//$Id: menu-res.h,v 1.10 2002/01/01 21:23:39 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001-2002 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifndef GUIKACHU_MENU_RES_H
#define GUIKACHU_MENU_RES_H

namespace Guikachu
{
    namespace Resources
    {
	struct MenuItem;
	struct Submenu;
	class Menu;
    }
}

#include "resource.h"

#include <vector>

namespace Guikachu
{
    namespace GUI
    {
	class MenuWindow;
    }
    
    namespace Resources
    {
	struct MenuItem
	{
	    bool        separator;
	    std::string id;
	    std::string label;
	    char        shortcut;
	};

	struct Submenu
	{
	    std::string           label;
	    std::vector<MenuItem> items;

	    Submenu () {};
	    Submenu (const std::string& label_): label (label_) {};
	};
	
	class Menu: public Resource
	{
	    typedef std::vector<Submenu> MenuTree;
	    
	    Guikachu::GUI::MenuWindow *gui;
	    MenuTree submenus;
	public:
	    Menu (const std::string& id);
	    virtual ~Menu ();
	    
	    virtual Type get_type () const { return RESOURCE_MENU; };
	    virtual void show_ui ();

	    MenuTree get_submenus () const { return submenus; };
	    void     set_submenus (const MenuTree& submenus);
	    
	private:
	    virtual bool load (StorageNode &node);
	    virtual void save (StorageNode &node) const;
	    virtual void save_rcp (std::ostream &ostr) const;
	};
    };
};

#endif /* !GUIKACHU_MENU_RES_H */
