//$Id: menu-res.cc,v 1.15 2002/01/01 21:23:39 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001-2002 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include "menu-res.h"
#include "menu-win.h"

#include <gnome-xml/xmlmemory.h>

using namespace Guikachu;
using namespace Guikachu::Resources;
using std::string;
using std::vector;
using std::ostream;

Menu::Menu (const string& id):
    Resource (id),
    gui (0)
{
}

Menu::~Menu ()
{
    delete gui;
}

void Menu::show_ui ()
{
    if (!gui)
	gui = new GUI::MenuWindow (this);

    gui->show ();
}

static bool register_menu (const vector<Submenu>& menu)
{
    bool success = true;
    
    for (vector<Submenu>::const_iterator i = menu.begin ();
	 i != menu.end (); i++)
    {
	for (vector<MenuItem>::const_iterator j = i->items.begin ();
	     j != i->items.end (); j++)
	{
	    if (!j->separator)
		if (!ResourceManager::register_id (j->id))
		    success = false;
	}
    }

    return success;
}

static void deregister_menu (const vector<Submenu>& menu)
{
    for (vector<Submenu>::const_iterator i = menu.begin ();
	 i != menu.end (); i++)
    {
	for (vector<MenuItem>::const_iterator j = i->items.begin ();
	     j != i->items.end (); j++)
	{
	    if (!j->separator)
		ResourceManager::unregister_id (j->id);
	}
    }
}

void Menu::set_submenus (const vector<Submenu>& new_menu)
{
    vector<Submenu> old_submenus = submenus;
    
    deregister_menu (submenus);    
    if (!register_menu (new_menu))
    {
	deregister_menu (new_menu);
	register_menu (submenus);
    } else {
	submenus = new_menu;
    }

    changed ();
}

bool Menu::load (StorageNode &node)
{
    for (StorageNode curr_node  = node.children ();
	 curr_node; curr_node++)
    {
	if (curr_node.name () == "submenu")
	{
	    Submenu submenu;
	    string label = curr_node.get_prop<string> ("label");
	    
	    if (label == "")
		break;
	    
	    submenu.label = label;
	    
	    for (StorageNode sub_node = curr_node.children ();
		 sub_node; sub_node++)
	    {
		MenuItem menu_item;
		if (sub_node.name () == "menuitem")
		{
		    string id = sub_node.get_prop<string> ("id");
		    string label = sub_node.get_prop<string> ("label");
		    char   shortcut = sub_node.get_prop<char> ("shortcut");

		    if (id == "" || label == "")
			break;

		    menu_item.separator = false;

		    menu_item.id = id;
		    menu_item.label = label;		    
		    menu_item.shortcut = shortcut;

		    submenu.items.push_back (menu_item);
		}
		else if (sub_node.name () == "separator")
		{
		    menu_item.separator = true;

		    submenu.items.push_back (menu_item);
		}
		else
		    g_warning ("Error parsing `menu' resource: "
			       "unexpected element `%s/%s'",
			       curr_node.name ().c_str (),
			       sub_node.name ().c_str ());
	    }

	    submenus.push_back (submenu);
	}	    
	else
	    g_warning ("Error parsing `menu' resource: "
		       "unexpected element `%s'", curr_node.name ().c_str ());

    }
    
    changed ();
    
    return true;
}

void Menu::save (StorageNode &node) const
{
    StorageNode submenu_node, item_node;
    
    for (vector<Submenu>::const_iterator i = submenus.begin ();
	 i != submenus.end (); i++)
    {
	submenu_node = node.add_node ("submenu");
	submenu_node.set_prop ("label", i->label);

	for (vector<MenuItem>::const_iterator j = i->items.begin ();
	     j != i->items.end (); j++)
	{
	    if (j->separator)
	    {
		submenu_node.add_node ("separator");
	    } else {
		item_node = submenu_node.add_node ("menuitem");
		item_node.set_prop ("id",    j->id);
		item_node.set_prop ("label", j->label);

		if (j->shortcut)
		    item_node.set_prop ("shortcut", j->shortcut);
	    }
	}
    }
}

void Menu::save_rcp (ostream &ostr) const
{
    ostr << "MENU ID " << id << std::endl;

    ostr << "BEGIN" << std::endl;

    for (vector<Submenu>::const_iterator i = submenus.begin ();
	 i != submenus.end (); i++)
    {
	ostr << "  PULLDOWN \"" << i->label << "\"" << std::endl;
	
	ostr << "  BEGIN" << std::endl;
	for (vector<MenuItem>::const_iterator j = i->items.begin ();
	     j != i->items.end (); j++)
	{
	    if (j->separator)
		ostr << "    MENUITEM SEPARATOR" << std::endl;
	    else
	    {
		ostr << "    MENUITEM \"" << j->label << "\" ID " << j->id;
		if (j->shortcut)
		    ostr << " \"" << j->shortcut << "\"";
		ostr << std::endl;
	    }
	}
	ostr << "  END" << std::endl;
    }
    
    ostr << "END" << std::endl
	 << std::endl;
}
