//$Id: table-canvas.cc,v 1.9 2002/01/01 21:23:41 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001-2002 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include "table-canvas.h"

#include "form-editor.h"

#include <gnome--/canvas-polygon.h>
#include <gnome--/canvas-line.h>

using namespace Guikachu::GUI::FormEditor;

TableCanvasItem::TableCanvasItem (Widgets::Table     *widget_,
				  Gnome::CanvasGroup *parent_group):
    WidgetCanvasItem (widget_, parent_group),
    widget (widget_),
    group (0)
{
    update ();
}

void TableCanvasItem::update ()
{
    if (group)
	delete group;

    group = new Gnome::CanvasGroup (*parent_group, 0, 0);

    const std::vector<int> &columns = widget->column_width;

    
    using Gnome::Art::Point;
    using namespace Gnome::CanvasHelpers;
    
    static const char stipple_bits[] = { 0x02, 0x01, };
    GdkBitmap *stipple = gdk_bitmap_create_from_data (NULL,
						      stipple_bits,
						      2, 2);
    
    /* Column separators */
    int width  = 0;
    int height = widget->num_rows * 11;

    int x1 = widget->x;
    int y1 = widget->y;
    int y2 = y1 + height;
    
    int num_columns = widget->num_columns;
    for (int i = 0; i < num_columns; i++)
    {
	width += columns[i] + 1;
	int line_x = x1 + width;
	
	Gnome::CanvasPoints line_points;
	
	line_points.push_back (Point (line_x, y1));
	line_points.push_back (Point (line_x, y2));
			       
	*(new Gnome::CanvasLine (*group, line_points))
	    << fill_color (get_foreground_color (true))
	    << fill_stipple (stipple);
    }

    int x2 = x1 + width;

    /* A Polygon is used instead of a Rectangle to get mouse events
     * inside the "hollow" area
     */
    Gnome::CanvasPoints frame_points;
    using Gnome::Art::Point;
    using namespace Gnome::CanvasHelpers;
    
    frame_points.push_back (Point (x1, y1));
    frame_points.push_back (Point (x2, y1));
    frame_points.push_back (Point (x2, y2));
    frame_points.push_back (Point (x1, y2));
    frame_points.push_back (Point (x1, y1));

    *(new Gnome::CanvasPolygon (*group, frame_points))
	<< outline_color (get_foreground_color (true))
	<< outline_stipple (stipple);
    
    /* Row separators */
    int row_step = 11;
    int row_y = y1;
    for (int i = 0; i < widget->num_rows; i++)
    {
	Gnome::CanvasPoints line_points;
	
	line_points.push_back (Point (x1, row_y));
	line_points.push_back (Point (x2, row_y));
			       
	*(new Gnome::CanvasLine (*group, line_points))
	    << fill_color (get_foreground_color (true))
	    << fill_stipple (stipple);
	
	row_y += row_step;
    }
    
    gdk_bitmap_unref (stipple);
    
    set_canvas_item (group);
}
