//$Id: scrollbar-canvas.cc,v 1.14 2002/01/01 21:23:40 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001-2002 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

/* This code may need a clean-up, but it Works(tm) at the moment */

#include "scrollbar-canvas.h"

#include "form-editor.h"

#include <gdk-pixbuf/gnome-canvas-pixbuf.h>

using namespace Guikachu::GUI::FormEditor;

ScrollBarCanvasItem::ScrollBarCanvasItem (Widgets::ScrollBar *widget_,
					  Gnome::CanvasGroup *parent_group):
    WidgetCanvasItem (widget_, parent_group),
    widget (widget_),
    group (0)
{
    update ();
}

static void free_pixdata_gfree (guchar *pixels, gpointer data)
{
    g_free (pixels);
}

void ScrollBarCanvasItem::update ()
{
    if (group)
	delete group;

    using namespace Gnome::CanvasHelpers;

    group = new Gnome::CanvasGroup (*parent_group, 0, 0);

    int width = widget->get_display_width ();
    int height = widget->height;

    int x1 = widget->x;
    int y1 = widget->y;
    int y2 = y1 + height;


    // Step 1: the arrows
    int arrow_width  = width;
    int arrow_height = (arrow_width + 1) / 2;
    // FIXME: sanity checks to ensure width/height things

    guchar *up_pixbuf_data = g_new0 (guchar, arrow_width * arrow_height * 4);
    guchar *dn_pixbuf_data = g_new0 (guchar, arrow_width * arrow_height * 4);
    Gdk_Color color = get_foreground_color (widget->usable);

    int row_indent = 0;
    for (int row = arrow_height; row > 0; row--, row_indent++)
    {
	int y_up_offset = arrow_width * (row - 1);
	int y_dn_offset = arrow_width * (arrow_height - row);
	
	int row_max_x = arrow_width - row_indent;
	
	for (int x = row_indent; x < row_max_x; x++)
	{
	    up_pixbuf_data[((y_up_offset + x) * 4) + 0] = color.red >> 8;
	    up_pixbuf_data[((y_up_offset + x) * 4) + 1] = color.green >> 8;
	    up_pixbuf_data[((y_up_offset + x) * 4) + 2] = color.blue >> 8;
	    up_pixbuf_data[((y_up_offset + x) * 4) + 3] = 255;

	    dn_pixbuf_data[((y_dn_offset + x) * 4) + 0] = color.red >> 8;
	    dn_pixbuf_data[((y_dn_offset + x) * 4) + 1] = color.green >> 8;
	    dn_pixbuf_data[((y_dn_offset + x) * 4) + 2] = color.blue >> 8;
	    dn_pixbuf_data[((y_dn_offset + x) * 4) + 3] = 255;
	}
    }
    
    
    GdkPixbuf *up_pixbuf = gdk_pixbuf_new_from_data (up_pixbuf_data,
						     GDK_COLORSPACE_RGB,
						     true,
						     8,
						     arrow_width, arrow_height,
						     arrow_width * 4,
						     free_pixdata_gfree, 0);

    GdkPixbuf *dn_pixbuf = gdk_pixbuf_new_from_data (dn_pixbuf_data,
						     GDK_COLORSPACE_RGB,
						     true,
						     8,
						     arrow_width, arrow_height,
						     arrow_width * 4,
						     free_pixdata_gfree, 0);
    gnome_canvas_item_new (group->gtkobj (),
			   gnome_canvas_pixbuf_get_type (),
			   "pixbuf", up_pixbuf,
			   "x", (double)(x1),
			   "y", (double)(y1 + 1),
			   0);
    gnome_canvas_item_new (group->gtkobj (),
			   gnome_canvas_pixbuf_get_type (),
			   "pixbuf", dn_pixbuf,
			   "x", (double)(x1),
			   "y", (double)(y2 - arrow_height - 1),
			   0);
    gdk_pixbuf_unref (up_pixbuf);
    gdk_pixbuf_unref (dn_pixbuf);
    
    // Step 2: the scrolling range

    /* FIXME: the scrolling range should have a minimum width of 1 */
    int range_height = height - 2 * (arrow_height + 2);
    int range_width = MAX (width - 4, 0);
    int range_x1 = x1 + 2;
    int range_x2 = range_x1 + range_width;
    int range_y1 = y1 + arrow_height + 2;
    int range_y2 = range_y1 + range_height;
    
    /* Data for the GdkBitmap to use as a fill stipple */
    char stipple_bits[] = { 0x02, 0x01 };
    GdkBitmap *stipple = gdk_bitmap_create_from_data (NULL,
						      stipple_bits,
						      2, 2);
    
    *(FormEditor::draw_rectangle (*group,
				  range_x1, range_y1,
				  range_x2, range_y2))
	    << fill_stipple (stipple)
	    << fill_color (get_foreground_color (widget->usable));
    gdk_bitmap_unref (stipple);

    // Step 3: The value marker

    int value_range_size = widget->max_value - widget->min_value;

    int slider_size = 10;
    if (widget->page_size)
    {
	double page_ratio = (double) value_range_size / (double) widget->page_size;
	double page_size = 1.0 / (page_ratio + 1.0) * range_height;

	if (page_size > 10)
	    slider_size = (int) page_size;
    }
    
    int slider_y = 0;
    if (value_range_size)
    {
	int value_abs = widget->value - widget->min_value;
	double value_ratio = (double)value_abs / (double)value_range_size;

	if (value_ratio < 0)
	    value_ratio = 0;
	
	if (value_ratio > 1)
	    value_ratio = 1;

	slider_y = (int) (value_ratio * (range_height - slider_size));
    }
    
    int slider_top = range_y1 + slider_y;
    int slider_bottom = slider_top + slider_size;
    
    // Space around the mark
    *(FormEditor::draw_rectangle (*group,
				  range_x1, slider_top - 1,
				  range_x2, slider_bottom + 1))
        << fill_color (get_background_color ());

    // The mark itself
    *(FormEditor::draw_rectangle (*group,
				  range_x1, slider_top,
				  range_x2, slider_bottom))
      << fill_color (get_foreground_color (widget->usable));
	
    set_canvas_item (group);
}
