//$Id: form-canvas.cc,v 1.2 2002/01/01 21:23:40 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001-2002 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include "form-editor/form-canvas.h"

#include "config.h"
#include <libgnome/libgnome.h>

#include <gnome--/canvas-group.h>
#include <gnome--/canvas-polygon.h>
#include <gnome--/canvas-rect.h>
#include <gdk-pixbuf/gnome-canvas-pixbuf.h>
#include <sigc++/retbind.h>
#include <gnome--/app-helper.h>
#include <libgnomeui/gnome-stock.h>

#include <list>
#include <math.h>

#include "form-editor/form-editor.h"

using namespace Guikachu::GUI::FormEditor;

#define GUIKACHU_WINDOW_TITLE_HEIGHT 13

FormCanvasItem::FormCanvasItem (Widgets::Form      *form_widget,
				Gnome::CanvasGroup *parent_group):
    CanvasItem (form_widget, parent_group),
    res (form_widget->get_resource ()),
    group (0),
    background_item (0),
    frame_group (0),
    title_group (0),
    widget_group (0)
{
    using namespace SigC;

    group = new Gnome::CanvasGroup (*parent_group, 0, 0);
    widget_group = new Gnome::CanvasGroup (*group, 0, 0);

    // Popup menu
    std::list <Gnome::UI::Info> popup_menu_list;
    popup_menu_list.push_back (
	Gnome::UI::Item (Gnome::UI::Icon (GNOME_STOCK_MENU_PROP),
			 _("_Edit"), clicked.slot ()));
    Gnome::UI::fill (popup_menu, popup_menu_list, *(popup_menu.get_accel_group ()));

    res->changed.connect (slot (this, &FormCanvasItem::update));
    update ();
}

void FormCanvasItem::update ()
{
    draw_background ();
    draw_frame ();
    draw_title ();

    group->set_x (0);
    group->set_y (0);
    group->move (res->x, res->y);

    widget_group->raise_to_top ();
}

void FormCanvasItem::move (int dx, int dy)
{
    group->move (dx, dy);
}

Gnome::CanvasGroup *FormCanvasItem::get_widget_group ()
{
    return widget_group;
}

void FormCanvasItem::draw_background ()
{
    using namespace Gnome::CanvasHelpers;
    delete background_item;
    background_item = new Gnome::CanvasRect (*parent_group,
					     0, 0,
					     FormEditor::get_screen_width () - 1,
					     FormEditor::get_screen_height () - 1);
    *background_item
	<< width_pixels (0)
	<< fill_color (get_background_color ());
    background_item->lower_to_bottom ();
}

void FormCanvasItem::draw_frame ()
{
    delete frame_group;
    frame_group = new Gnome::CanvasGroup (*group, 0, 0);
    
    Gnome::CanvasRect *frame_rect =
	new Gnome::CanvasRect (*frame_group,
			       -1, -1,
			       res->width, res->height);
    frame_rect->set_width_units (1);
    frame_rect->set_fill_color ("");
    
    if (res->modal)
	draw_frame_modal ();
    else
	if (res->frame)
	    draw_frame_nonmodal ();
}

void FormCanvasItem::draw_frame_nonmodal ()
{
    Gnome::CanvasRect *frame_rect =
	new Gnome::CanvasRect (*frame_group,
			       -1, -1,
			       res->width, res->height);
    
    frame_rect->set_width_units (1);
    frame_rect->set_outline_color (get_foreground_color (true));
    frame_rect->set_fill_color ("");
}

static void free_pixdata_delete (guchar *pixels, gpointer closure)
{
    delete pixels;
}

static GdkPixbuf *draw_solid (int width, int height)
{
    static Gdk_Color color (get_foreground_color (true));
    static guchar red   = color.red >> 8;
    static guchar green = color.green >> 8;
    static guchar blue  = color.blue >> 8;
    
    int num_pixels = width * height;
    guchar *pixbuf_data = new guchar[width * height * 4];
    
    for (int offset = 0; offset < num_pixels * 4; offset += 4)
    {
	pixbuf_data[offset + 0] = red;
	pixbuf_data[offset + 1] = green;
	pixbuf_data[offset + 2] = blue;
	pixbuf_data[offset + 3] = 255;	
    }

    return gdk_pixbuf_new_from_data (pixbuf_data,
				     GDK_COLORSPACE_RGB,
				     true,
				     8,
				     width, height,
				     width * 4,
				     free_pixdata_delete, 0);
    
}

void FormCanvasItem::draw_frame_modal ()
{
    int width = res->width - 1;
    int height = res->height - 1;

    GdkPixbuf *pixbuf;

    pixbuf = draw_solid (width + 1, 2);
    FormEditor::draw_pixbuf (*frame_group, pixbuf, 0, -2);
    FormEditor::draw_pixbuf (*frame_group, pixbuf, 0, height + 1);
    gdk_pixbuf_unref (pixbuf);

    pixbuf = draw_solid (2, height + 1);
    FormEditor::draw_pixbuf (*frame_group, pixbuf, -2, 0);
    FormEditor::draw_pixbuf (*frame_group, pixbuf, width + 1, 0);
    gdk_pixbuf_unref (pixbuf);

    pixbuf = draw_solid (2, 2);
    FormEditor::draw_pixbuf (*frame_group, pixbuf, -1, -1);
    FormEditor::draw_pixbuf (*frame_group, pixbuf, width, -1);
    FormEditor::draw_pixbuf (*frame_group, pixbuf, width, height);
    FormEditor::draw_pixbuf (*frame_group, pixbuf, -1, height);
    gdk_pixbuf_unref (pixbuf);
}

void FormCanvasItem::draw_title ()
{
    delete title_group;
    title_group = new Gnome::CanvasGroup (*group, 0, 0);

    set_canvas_item (title_group);
    title_group->event.connect (SigC::retbind (
	SigC::slot (this, &FormCanvasItem::canvas_event_cb), 1));

    if (res->modal)
	draw_title_modal ();
    else
	draw_title_nonmodal ();
}

void FormCanvasItem::draw_title_nonmodal ()
{
    Gnome::CanvasPoints points;
    int title_width;
    const Font &font = get_title_font ();

    title_width = get_string_width (1, res->title); /* Title is font#1 (FIXME) */
    title_width = std::min<int> (title_width + 4, res->width);

    int max_width = res->width;
    int max_height = std::min<int> (res->height, GUIKACHU_WINDOW_TITLE_HEIGHT);
    
    // NW corner
    points.push_back (Gnome::Art::Point (0, 1));
    points.push_back (Gnome::Art::Point (1, 0));

    // NE corner
    points.push_back (Gnome::Art::Point (title_width,     0));
    points.push_back (Gnome::Art::Point (title_width + 1, 1));

    // SE corner
    points.push_back (Gnome::Art::Point ((title_width + 1), (GUIKACHU_WINDOW_TITLE_HEIGHT + 1)));
    // SW corner
    points.push_back (Gnome::Art::Point (0, (GUIKACHU_WINDOW_TITLE_HEIGHT + 1)));
    // Back to NW
    points.push_back (Gnome::Art::Point (0, 1));

    {
	using namespace Gnome::CanvasHelpers;

	*(new Gnome::CanvasPolygon (*title_group, points))
	    << width_units (1)
	    << fill_color (get_foreground_color (true));

	render_text (*title_group, res->title, font,
		     get_background_color (),
		     3, 2,
		     GTK_ANCHOR_NW,
		     max_width, max_height);
	
	*(new Gnome::CanvasRect (*title_group,
				 0, GUIKACHU_WINDOW_TITLE_HEIGHT,
				 res->width - 1, GUIKACHU_WINDOW_TITLE_HEIGHT + 1))
	    << width_units (1)
	    << fill_color (get_foreground_color (true));
    }
}

void FormCanvasItem::draw_title_modal ()
{
    Gnome::CanvasPoints points;
    const Font &font = get_title_font ();

    int title_center = res->width / 2;
    int title_height = std::min<int> (res->height, 11);

    int max_width = res->width;
    int max_height = std::min<int> (res->height, 11);

    {
	using namespace Gnome::CanvasHelpers;
    
	*(new Gnome::CanvasRect (*title_group,
				 0, 0,
				 res->width, title_height))
	    << width_units (1)
	    << fill_color (get_foreground_color (true));

	render_text (*title_group, res->title, font,
		     get_background_color (),
		     title_center, 0,
		     GTK_ANCHOR_N,
		     max_width, max_height);
    }
}

void FormCanvasItem::selected_cb (bool selected)
{
}

void FormCanvasItem::canvas_event_cb (GdkEvent *e)
{
    // Context menu
    if ((e->type == GDK_BUTTON_PRESS) &&
	(e->button.button == 3))
	popup_menu.popup (e->button.button, e->button.time);
}
