//$Id: app-win.cc,v 1.14 2002/01/03 17:19:35 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001-2002 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include "app-win.h"

#include "config.h"
#include <libgnome/libgnome.h>

#ifdef GUIKACHU_USE_WM_ICONS
#include <libgnomeui/gnome-window-icon.h>
#endif

#include "target.h"

#include "widgets/entry.h"
#include "widgets/target-combo.h"
#include "widgets/num-entry.h"

#include <gtk--/menu.h>
#include <gtk--/optionmenu.h>

using namespace Guikachu;

GUI::AppWindow::AppWindow (Resources::Application *res_):
    res (res_)
{
    using namespace SigC;
    
    window = new Gtk::Window (GTK_WINDOW_DIALOG);
    window->set_policy (false, false, false);
    window->delete_event.connect (SigC::slot (this, &AppWindow::delete_event_impl));

#ifdef GUIKACHU_USE_WM_ICONS
    gnome_window_icon_set_from_file (window->gtkobj (), GNOME_ICONDIR "/guikachu.png");
#endif    

    Target *target = ResourceManager::get_target ();

    proptable = new GUI::PropertyTable ();
    Gtk::Widget *control;
    
    /* Icon caption */
    control = new GUI::PropertyEditors::Entry (false, res->iconname);
    proptable->add (_("Icon _caption:"), *manage (control));

    /* Version */
    control = new GUI::PropertyEditors::Entry (false, res->version);
    proptable->add (_("_Version:"), *manage (control));

    /* Vendor ID */
    control = new GUI::PropertyEditors::Entry (false, res->vendor);
    static_cast<Gtk::Entry*>(control)->set_max_length (4);
    proptable->add (_("Vendor _ID:"), *manage (control));

    /* Target machine */
    GUI::PropertyEditors::TargetCombo *target_combo = new GUI::PropertyEditors::TargetCombo;
    target_combo->stock_selected.connect (SigC::slot (this, &AppWindow::stock_target_cb));
    target_combo->custom_selected.connect (SigC::slot (this, &AppWindow::custom_target_cb));
	
    control = target_combo;
    proptable->add (_("_Target machine:"), *manage (control));

    /* Custom target machine */
    control = custom_target_width =
	new PropertyEditors::NumEntry (0, 2 << 7, target->screen_width);
    proptable->add (_("Screen _width: "), *manage (control));

    control = custom_target_height =
	new PropertyEditors::NumEntry (0, 2 << 7, target->screen_height);
    proptable->add (_("Screen _height: "), *manage (control));

    proptable->show_all ();
    window->add (*manage (proptable));

    if (target->get_stock_id () != "")
	stock_target_cb ();
    
    res->changed.connect (slot (this, &AppWindow::update));
    update ();
}

GUI::AppWindow::~AppWindow ()
{
    delete window;
}

int GUI::AppWindow::delete_event_impl (GdkEventAny *e)
{
    window->hide ();
    return true;
}

void GUI::AppWindow::show ()
{
    window->show ();
    window->get_window ().raise ();
}

void GUI::AppWindow::hide ()
{
    window->hide ();
}

void GUI::AppWindow::update ()
{
    gchar *title_buf = g_strdup_printf (_("Application: %s"), res->iconname ().c_str ());
    window->set_title (title_buf);
    g_free (title_buf);
}

void GUI::AppWindow::stock_target_cb ()
{
    proptable->set_child_shown (*custom_target_width,  false);
    proptable->set_child_shown (*custom_target_height, false);
}

void GUI::AppWindow::custom_target_cb ()
{
    proptable->set_child_shown (*custom_target_width,  true);
    proptable->set_child_shown (*custom_target_height, true);
}
