//$Id: string-list.cc,v 1.11 2001/12/15 12:21:37 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include "string-list.h"

#include "config.h"
#include <libgnome/libgnome.h>

#include <gtk--/scrolledwindow.h>
#include <gtk--/buttonbox.h>
#include <gnome--/stock.h>

using namespace Guikachu::GUI::PropertyEditors;

StringList::StringList (Property<value_t> &property_):
    Gtk::HBox (false, 5),
    property (property_),
    buttons (new Gtk::VButtonBox),
    update_block (false)
{
    using namespace SigC;

    set_border_width (5);
    
    /* Left pane: list of strings and an entry to edit the current
     * item */
    Gtk::VBox *vbox = new Gtk::VBox (false, 5);
    add (*manage (vbox));
    
    /* The List holding the strings */
    list_widget.set_selection_mode (GTK_SELECTION_BROWSE);
    list_widget.selection_changed.connect (slot (this, &StringList::selection_cb));
    
    Gtk::ScrolledWindow *scrollwin = new Gtk::ScrolledWindow;
    scrollwin->add_with_viewport (list_widget);
    scrollwin->set_policy (GTK_POLICY_AUTOMATIC,
			   GTK_POLICY_AUTOMATIC);
    
    scrollwin->show_all ();
    vbox->add (*manage (scrollwin));

    /* The Entry for editing items */
    entry.activate.connect (slot (this, &StringList::entry_activate_cb));
    
    vbox->pack_start (entry, false, false);
    
    /* The modifier buttons */
    btnAdd  = Gtk::wrap (GTK_BUTTON (
	gnome_pixmap_button (
	    GTK_WIDGET (manage(new Gnome::Stock::Pixmap (GNOME_STOCK_PIXMAP_ADD))->gtkobj ()),
	    _("Add"))));
    btnAdd->clicked.connect (slot (this, &StringList::button_add_cb));

    btnRemove  = Gtk::wrap (GTK_BUTTON (
	gnome_pixmap_button (
	    GTK_WIDGET (manage(new Gnome::Stock::Pixmap (GNOME_STOCK_PIXMAP_REMOVE))->gtkobj ()),
	    _("Remove"))));
    btnRemove->clicked.connect (slot (this, &StringList::button_remove_cb));
	
    btnUp   = new Gnome::Stock::Button (GNOME_STOCK_BUTTON_UP);
    btnUp->clicked.connect (slot (this, &StringList::button_up_cb));
	
    btnDown = new Gnome::Stock::Button (GNOME_STOCK_BUTTON_DOWN);
    btnDown->clicked.connect (slot (this, &StringList::button_down_cb));
    
    buttons->add (*manage (btnUp));
    buttons->add (*manage (btnDown));
    buttons->add (*manage (btnRemove));
    buttons->add (*manage (btnAdd));
    buttons->show_all ();
    pack_start (*manage (buttons), false, false);
    
    property.changed.connect (slot (this, &StringList::update));
    update ();
    selection_cb ();
}

void StringList::add_button (Gtk::Widget &button)
{
    Gtk::Box::BoxList &box_list = buttons->children ();
    box_list.insert (box_list.find (*btnRemove), button);
}

void StringList::clear_list ()
{
    list_widget.items ().clear ();
}

void StringList::add_to_list (int                index,
			      const std::string &label)
{
    Gtk::ListItem *item = new Gtk::ListItem (label);
    item->show ();
    item->set_user_data (GUINT_TO_POINTER (index));
    
    list_widget.items ().push_back (*manage (item));
}

void StringList::update ()
{
    update_block = true;

    static value_t last_val;    
    const value_t &curr_val = property;

    if (curr_val != last_val)
    {
	clear_list ();
	
	unsigned int index = 0;
	for (value_t::const_iterator i = curr_val.begin ();
	     i != curr_val.end (); i++, index++)
	    add_to_list (index, *i);

	last_val = curr_val;
    }

    update_block = false;
}

void StringList::selection_cb ()
{
    Gtk::List::SelectionList sel_list = list_widget.selection ();

    if (!sel_list.size ())
    {
	
	btnUp->set_sensitive (false);
	btnDown->set_sensitive (false);

	Gtk::Box::BoxList::iterator begin = ++buttons->children ().find (*btnDown);
	Gtk::Box::BoxList::iterator end = buttons->children ().find (*btnAdd);
	for (Gtk::Box::BoxList::iterator i = begin; i != end; i++)
	    (*i)->get_widget ()->set_sensitive (false);
	
	entry.set_text ("");
	
    } else {

	if (update_block)
	    return;
	
	g_return_if_fail (sel_list.size() == 1);

	unsigned int index = GPOINTER_TO_UINT ((*(sel_list.begin()))->get_user_data ());
	
	btnUp->set_sensitive ((index > 0));
	btnDown->set_sensitive ((index < (property ().size () - 1)));

	Gtk::Box::BoxList::iterator begin = ++buttons->children ().find (*btnDown);
	Gtk::Box::BoxList::iterator end = buttons->children ().find (*btnAdd);
	for (Gtk::Box::BoxList::iterator i = begin; i != end; i++)
	    (*i)->get_widget ()->set_sensitive (true);

	entry.set_text (property ()[index]);
    }
}

unsigned int StringList::get_selected_row ()
{
    g_return_val_if_fail (list_widget.selection ().size () == 1, 0);

    Gtk::List::SelectionList::iterator sel = list_widget.selection ().begin ();  
    return GPOINTER_TO_UINT ((*sel)->get_user_data ());
}

void StringList::button_remove_cb ()
{
    unsigned int index = get_selected_row ();
    value_t val = property;
    val.erase (val.begin () + index);
    property = val;

    index = MIN (index, property ().size () - 1);

    item_removed.emit (index);
    
    list_widget.unselect_item (index);
    list_widget.select_item (index);
}

void StringList::button_up_cb ()
{
    unsigned int index = get_selected_row ();
    g_return_if_fail (index != 0);

    value_t val = property;
    value_t::iterator curr = val.begin () + index;
    value_t::iterator prev = curr - 1;
    iter_swap (curr, prev);
    property = val;
    
    up.emit (index);
    
    list_widget.unselect_item (index - 1);
    list_widget.select_item (index - 1);
}

void StringList::button_down_cb ()
{
    unsigned int index = get_selected_row ();
    g_return_if_fail (index < list_widget.items ().size () - 1);

    value_t val = property;
    value_t::iterator curr = val.begin () + index;
    value_t::iterator next = curr + 1;
    iter_swap (curr, next);
    property = val;

    down.emit (index);

    list_widget.unselect_item (index + 1);
    list_widget.select_item (index + 1);
}

void StringList::button_add_cb ()
{
    unsigned int index = 0;
    
    if (list_widget.selection ().size ())
	index = GPOINTER_TO_UINT ((*(list_widget.selection ().begin ()))->get_user_data ());

    std::string item_text = entry.get_text ();
    if (item_text == "")
	return;
    
    value_t curr_val = property;
    value_t::iterator pos = curr_val.begin () + index + 1;
    if (index == curr_val.size ())
	curr_val.push_back (item_text);
    else
	curr_val.insert (pos, item_text);
    property = curr_val;

    item_added.emit (index + 1);
    
    list_widget.select_item (index + 1);
}

void StringList::entry_activate_cb ()
{
    if (!list_widget.selection ().size ())
    {
	button_add_cb ();
	return;
    }

    std::string new_text = entry.get_text ();
    if (new_text == "")
    {
	return;
    }
	
    unsigned int index = get_selected_row ();
    value_t val = property;

    val[index] = new_text;
    property = val;

    list_widget.select_item (index);
}
