//$Id: auto-toggle.cc,v 1.3 2001/12/09 18:56:03 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include "auto-toggle.h"

using namespace Guikachu::GUI::PropertyEditors;

AutoToggle::AutoToggle (Gtk::Widget    &widget_,
			Property<bool> &property_):
    PropertyEditor (this),
    widget (widget_),
    property (property_),
    update_block (false)
{
    using namespace SigC;
    
    togglebutton.show ();
    pack_start (togglebutton, false, false);

    widget.show ();
    pack_start (widget);
    
    togglebutton.clicked.connect (slot (this, &AutoToggle::clicked_cb));
    
    property.changed.connect (slot (this, &AutoToggle::update));
    update ();
}

void AutoToggle::update ()
{
    update_block = true;

    togglebutton.set_active (property);
    widget.set_sensitive (property);
    
    update_block = false;
}

void AutoToggle::clicked_cb ()
{
    if (!update_block)
	property = togglebutton.get_active ();
}
