//$Id: top-treeitem.cc,v 1.5 2001/12/15 12:21:36 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include "top-treeitem.h"

#include "config.h"
#include <libgnome/libgnome.h>

#include <gnome--/app-helper.h>
#include <libgnomeui/gnome-stock.h>
#include <list>

#include "resource-manager.h"

using namespace Guikachu;

GUI::TopTreeItem::TopTreeItem (Resources::Application *res_):
    res (res_)	 
{
    button_press_event.connect (slot (this, &GUI::TopTreeItem::clicked_cb));
    res->changed.connect (slot (this, &GUI::TopTreeItem::application_changed_cb));

    using Gnome::UI;
    
    std::list <UI::Info> popup_menu_list;
    popup_menu_list.push_back (
	UI::Item (UI::Icon (GNOME_STOCK_MENU_PROP),
		  _("_Edit"), SigC::slot (this, &GUI::TopTreeItem::menu_edit_cb)));
    UI::fill (popup_menu, popup_menu_list, *(popup_menu.get_accel_group ()));

    application_changed_cb ();
}

int GUI::TopTreeItem::clicked_cb (GdkEventButton *e)
{
    if (e->type == GDK_2BUTTON_PRESS && e->button == 1)
	res->show_ui ();

    if (e->button == 3)
	popup_menu.popup (e->button, e->time);

    return false;
}

void GUI::TopTreeItem::application_changed_cb ()
{
    remove ();

    if (res->iconname != "")
	add_label (res->iconname);
    else
	add_label (_("Application"));
}

void GUI::TopTreeItem::menu_edit_cb ()
{
    res->show_ui ();
}
