//$Id: string-res.cc,v 1.12 2001/12/09 15:23:02 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include "string-res.h"
#include "string-win.h"

using namespace Guikachu;
using std::string;

Resources::String::String (const string& id):
    Resource (id),
    gui (0),
    text (changed, "")
{
}

Resources::String::~String ()
{
    delete gui;
}

void Resources::String::show_ui ()
{
    if (!gui)
	gui = new GUI::StringWindow (this);

    gui->show ();
}

bool Resources::String::load (StorageNode &node)
{
    StorageNode curr_node;
    bool text_set = false;
    
    for (curr_node  = node.children ();
	 curr_node; curr_node  = curr_node.next ())
    {
	if (curr_node.name () == "text")
	{
	    text = curr_node.get_content ();
	    text_set = true;
	}
	else
	    g_warning ("Error parsing `string' resource: "
		       "unexpected element `%s'", curr_node.name ().c_str ());
    }

    if (!text_set)
	return false;

    changed ();
    
    return true;
}

void Resources::String::save (StorageNode &node) const
{
    node.add_node ("text", text);
}

void Resources::String::save_rcp (std::ostream &ostr) const
{
    ostr << "STRING ID " << id << " \"" << text << "\"" << std::endl
	 << std::endl;
}
