//$Id: preferences.h,v 1.4 2001/12/22 20:31:39 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifndef GUIKACHU_PREFERENCES_H
#define GUIKACHU_PREFERENCES_H

#include <string>
#include <sigc++/basic_signal.h>

namespace Guikachu
{
    namespace Preferences
    {
	void load ();
	void save ();
	
	namespace FormEditor
	{
	    extern SigC::Signal0<void> colors_changed;
	    std::string get_color_fg ();
	    std::string get_color_disabled ();
	    std::string get_color_bg ();
	    std::string get_color_selection ();

	    void set_colors (const std::string &color_fg,
			     const std::string &color_disabled,
			     const std::string &color_bg,
			     const std::string &selection);

	    float get_default_zoom ();
	    void  set_default_zoom (float default_zoom);
	}
    }
}

#endif /* !GUIKACHU_PREFERENCES_H */
