//$Id: preferences.cc,v 1.5 2001/12/22 20:31:39 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include "preferences.h"
#include <gconf/gconf-client.h>

namespace Guikachu
{
    namespace Preferences
    {
	namespace FormEditor
	{
	    static std::string color_fg ("#000000");	    
	    static std::string color_disabled ("#757575");
	    static std::string color_bg ("#90B398");
	    static std::string color_selection ("#ECFFA8");

	    static void gconf_color_cb (GConfClient  *client,
					   unsigned int  cnxn_id,
					   GConfEntry   *entry,
					   gpointer      user_data);
	    

	    static float default_zoom (1.0);
	    static void gconf_default_zoom_cb (GConfClient  *client,
					       unsigned int  cnxn_id,
					       GConfEntry   *entry,
					       gpointer      user_data);
	}

	GConfClient *gconf_client;	
    }
}

#define GCONF_ROOT "/apps/guikachu"

using namespace Guikachu;

void Preferences::load ()
{
    // Set up GConf client
    gconf_client = gconf_client_get_default ();
    gconf_client_add_dir (gconf_client, "/apps/guikachu",
			  GCONF_CLIENT_PRELOAD_RECURSIVE, 0);
    
    // Load initial values
#define GET_COLOR(color) gconf_client_get_string (gconf_client, GCONF_ROOT "/FormEditor/Colors/" color, 0)

    FormEditor::color_fg = GET_COLOR ("foreground");
    FormEditor::color_disabled = GET_COLOR ("foreground-disabled");
    FormEditor::color_bg = GET_COLOR ("background");
    FormEditor::color_selection = GET_COLOR ("selection");    
    
#undef GET_COLOR

    FormEditor::default_zoom = gconf_client_get_float (gconf_client, GCONF_ROOT "/FormEditor/default_zoom", 0);
    
    // Set up GConf callbacks
    gconf_client_notify_add(gconf_client, GCONF_ROOT "/FormEditor/Colors/foreground",
			    FormEditor::gconf_color_cb,
			    &FormEditor::color_fg, 0, 0);
    gconf_client_notify_add(gconf_client, GCONF_ROOT "/FormEditor/Colors/foreground-disabled",
			    FormEditor::gconf_color_cb,
			    &FormEditor::color_disabled, 0, 0);
    gconf_client_notify_add(gconf_client, GCONF_ROOT "/FormEditor/Colors/background",
			    FormEditor::gconf_color_cb,
			    &FormEditor::color_bg, 0, 0);
    gconf_client_notify_add(gconf_client, GCONF_ROOT "/FormEditor/Colors/selection",
			    FormEditor::gconf_color_cb,
			    &FormEditor::color_selection, 0, 0);
}

void Preferences::save ()
{
    gtk_object_unref (GTK_OBJECT (gconf_client));
}

SigC::Signal0<void> Preferences::FormEditor::colors_changed;

void Preferences::FormEditor::set_colors (const std::string &color_fg_,
					  const std::string &color_disabled_,
					  const std::string &color_bg_,
					  const std::string &color_selection_)
{
#define SET_COLOR(key,value) if (value##_ != value) gconf_client_set_string (gconf_client, GCONF_ROOT "/FormEditor/Colors/" key, value##_.c_str (), 0)

    SET_COLOR("foreground", color_fg);
    SET_COLOR("foreground-disabled", color_disabled);
    SET_COLOR("background", color_bg);
    SET_COLOR("selection", color_selection);

#undef SET_COLOR
    
}

std::string Preferences::FormEditor::get_color_fg ()
{
    return color_fg;
}

std::string Preferences::FormEditor::get_color_disabled ()
{
    return color_disabled;
}

std::string Preferences::FormEditor::get_color_bg ()
{
    return color_bg;
}

std::string Preferences::FormEditor::get_color_selection ()
{
    return color_selection;
}

static void Preferences::FormEditor::gconf_color_cb (GConfClient  *client,
						     unsigned int  cnxn_id,
						     GConfEntry   *entry,
						     gpointer      user_data)
{
    const char  *new_val = gconf_value_get_string (gconf_entry_get_value (entry));
    std::string *val_store = static_cast<std::string*> (user_data);
    
    if (*val_store != new_val)
    {
	*val_store = new_val;
	colors_changed.emit ();
    }
}

float Preferences::FormEditor::get_default_zoom ()
{
    return default_zoom;
}

void Preferences::FormEditor::set_default_zoom (float default_zoom_)
{
    default_zoom = default_zoom_;
    gconf_client_set_float (gconf_client,
			    GCONF_ROOT "/FormEditor/default_zoom",
			    default_zoom, 0);
}
