//$Id: main.cc,v 1.14 2001/12/20 23:42:48 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include "config.h"

#include <gnome--/main.h>
#include <glade/glade.h>

#include <fcntl.h>

#ifdef GUIKACHU_USE_WM_ICONS
#include <libgnomeui/gnome-window-icon.h>
#endif

#include "mainwin.h"
#include "resource-manager.h"
#include "session.h"

namespace {
    enum FileType
    {
	FILETYPE_REGULAR,
	FILETYPE_GLADE,
	FILETYPE_FONT
    };
    
    struct FileEntry
    {
	const char *filename;
	FileType type;
    };
}
    
static bool check_file (FileEntry& file)
{
    bool        success  = true;
    std::string filename = file.filename;

    /* For _REGULAR and _FONT */
    int fd = -1;

    /* For _GLADE */
    GladeXML *gui = 0;
    
    switch (file.type)
    {
    case FILETYPE_REGULAR:
	fd = open (filename.c_str (), 0);
	if (fd == -1)
	    success = false;
	else
	    close (fd);
	break;
	
    case FILETYPE_GLADE:
	filename = std::string (GUIKACHU_GLADEDIR) + "/" + filename;
	gui = glade_xml_new (filename.c_str (), 0);
	if (!gui)
	    success = false;
	else
	    gtk_object_unref (GTK_OBJECT (gui));
	break;
	
    case FILETYPE_FONT:
	filename = std::string (GUIKACHU_FONTDIR) + "/" + filename;
	fd = open (filename.c_str (), 0);
	if (fd == -1)
	    success = false;
	else
	    close (fd);
	break;
    }

    return success;
}

static bool check_files ()
{
    bool success = true;
    
    FileEntry files[] = {
	{"guikachu.glade", FILETYPE_GLADE},
	{"stdfont.txt",    FILETYPE_FONT},
	{"boldfont.txt",   FILETYPE_FONT},
	{"bigfont.txt",    FILETYPE_FONT}
    };

    for (unsigned int i = 0;
	 i < (sizeof (files) / sizeof (FileEntry));
	 i++)
    {
	if (!check_file (files[i]))
	{
	    gchar *buffer = g_strdup_printf (
		_("Opening file `%s' (required by Guikachu) failed.\n"
		  "Check your Guikachu installation"),
		g_basename (files[i].filename));
	    Guikachu::GUI::show_error (buffer);
	    g_free (buffer);
	    
	    success = false;
	}
    }

    return success;
}

int main (int argc, char **argv)
{
#ifdef ENABLE_NLS
    bindtextdomain (PACKAGE, GNOME_LOCALEDIR);
    textdomain (PACKAGE);
#endif

    using namespace Guikachu;
    
    Main app (argc, argv);
    
    if (!check_files ())
	return -1;

#ifdef GUIKACHU_USE_WM_ICONS
    gnome_window_icon_set_default_from_file (GNOME_ICONDIR "/guikachu.png");
#endif
    
    GUI::MainWin main_win;
    
    const std::vector<std::string> &filenames = app.get_cmd_arguments ();
    std::string filename = "";

    if (filenames.size ())
    {
	for (std::vector<std::string>::const_iterator i = filenames.begin ();
	     i != filenames.end (); i++)
	    filename = *i;
	    
	ResourceManager::IOResult result = ResourceManager::load (filename);
	if (result == ResourceManager::IO_INVALID)
	{
	    gchar *buffer = g_strdup_printf (_("Unable to open `%s': "
					       "Not a valid Guikachu document"),
					     g_basename (filename.c_str ()));
	    GUI::show_error (buffer);
	    g_free (buffer);
	    ResourceManager::reset ();
	    
	} else {

	    app.set_filename (filename);
	    main_win.set_filename (filename);
	}
    }

    main_win.show_all ();
    app.run ();
}
