//$Id: widget.cc,v 1.16 2001/12/19 22:04:00 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include "widget.h"

#include "resource-manager.h"

using namespace Guikachu;

Widget::Widget (Resources::Form   *owner_,
		const std::string &id_):
    owner (owner_),
    editor (0),
    id (changed, id_),
    x (changed, 0),
    y (changed, 0)
{
}

Widget::~Widget ()
{
#if 0
    // FIXME: This will need a real PropertyEditor abstract class
    if (editor)
	delete editor;
#endif
    
    for (canvas_item_map_t::iterator i = canvas_items.begin ();
	 i != canvas_items.end (); i++)
	delete i->second;
}

std::ostream& Guikachu::operator<< (std::ostream &ostr, const Widget* res)
{
    res->save_rcp (ostr);
    return ostr;
}

Gtk::Widget* Widget::get_editor ()
{
    if (!editor)
	editor = create_editor ();

    return editor;
}

GUI::FormEditor::CanvasItem* Widget::get_canvas_item (GUI::FormEditor::Form *form)
{
    GUI::FormEditor::CanvasItem *ret;
    
    canvas_item_map_t::iterator found = canvas_items.find (form);
    if (found == canvas_items.end ())
	ret = canvas_items[form] = create_canvas_item (form);
    else
	ret = found->second;

    return ret;
}
