//$Id: resizeable.cc,v 1.3 2001/11/15 20:22:00 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include "resizeable.h"

#include <sigc++/signal_system.h>

using namespace Guikachu::Widgets;

Resizeable::Resizeable (SigC::Signal0<void> &changed):
    changed_propagate (changed),
    width (changed, 0),
    manual_width (manual_width_changed, false),
    height (changed, 0),
    manual_height (manual_height_changed, false)
{
    manual_width_changed.connect (SigC::slot (this, &Resizeable::manual_width_cb));
    manual_height_changed.connect (SigC::slot (this, &Resizeable::manual_height_cb));
}

int Resizeable::get_display_width () const
{
    if (manual_width && width != 0)
	return width;
    else
	return get_auto_width ();
}

int Resizeable::get_display_height () const
{
    if (manual_height && height != 0)
	return height;
    else
	return get_auto_height ();
}

void Resizeable::manual_width_cb ()
{
    if (width == 0)
	width = get_auto_width ();
    else
	changed_propagate.emit ();
}

void Resizeable::manual_height_cb ()
{
    if (height == 0)
	height = get_auto_height ();
    else
	changed_propagate.emit ();
}
