//$Id: pushbutton-canvas.cc,v 1.13 2001/12/16 15:44:30 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include "pushbutton-canvas.h"

#include "form-editor.h"

#include <gnome--/canvas-polygon.h>

using namespace Guikachu::GUI::FormEditor;

PushButtonCanvasItem::PushButtonCanvasItem (Widgets::PushButton *widget_,
					    FormEditor::Form    *form):
    CanvasItem (widget_, form),
    widget (widget_),
    group (0)
{
    update ();
}

void PushButtonCanvasItem::update ()
{
    if (group)
	delete group;

    group = new Gnome::CanvasGroup (*(form->get_canvas ()), 0, 0);
    
    int width = widget->get_display_width ();
    int height = widget->get_display_height ();

    /* Don't ask about the +1, I have no idea... */
    int x1 = widget->x - 1;
    int x2 = x1 + width + 1;
    int y1 = widget->y - 1;
    int y2 = y1 + height + 2;

    /* A Polygon is used instead of a Rectangle to get mouse events
     * inside the "hollow" area
     */
    using namespace Gnome::CanvasHelpers;

    *(FormEditor::draw_rectangle (*group, x1, y1, x2, y2))
	<< width_units (1)
	<< outline_color (get_foreground_color (widget->usable));
    
    int text_x = x1 + width / 2 + 1;
    int text_y = y1 + height / 2 + 1;

    draw_text (*group,
	       widget->text, widget->font,
	       text_x, text_y,
	       widget->usable,
	       GTK_ANCHOR_CENTER,
	       width, height);

    set_canvas_item (group);
}

void PushButtonCanvasItem::get_bounds (int &x1, int &y1,
				       int &x2, int &y2)
{
    x1 = widget->x - 1;
    x2 = x1 + widget->get_display_width () + 1;
    y1 = widget->y - 1;
    y2 = y1 + widget->get_display_height () + 2;
}
