//$Id: list-prop.cc,v 1.11 2001/12/19 17:56:51 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include "list-prop.h"

#include "config.h"
#include <libgnome/libgnome.h>

#include "widgets/entry.h"
#include "widgets/num-entry.h"
#include "widgets/pos-entry.h"
#include "widgets/togglebutton.h"
#include "widgets/size-entry.h"
#include "widgets/auto-toggle.h"
#include "widgets/propertytable.h"
#include "widgets/string-list.h"

#include <gtk--/notebook.h>

#include "widget-prop.h"

using namespace Guikachu::GUI::FormEditor;
using namespace Guikachu::Widgets;

ListProperties::ListProperties (List *res)
{
    using namespace Gtk;
    using namespace SigC;

    Gtk::Notebook *notebook = new Gtk::Notebook;

    /* Page 1: General properties */
    GUI::PropertyTable *proptable = new GUI::PropertyTable ();
    Gtk::Widget *control;

    /* Resource ID */
    WidgetProperties::add_general_controls (res, *proptable);

    /* Font */
    control = new GUI::PropertyEditors::NumEntry (0, 2, res->font);
    proptable->add (_("_Font:"), *manage (control));

    /* Number of visible items */
    control = new GUI::PropertyEditors::NumEntry (1, 20, res->visible_items);
    proptable->add (_("_Visible items:"), *manage (control));

    /* Usable */
    control = new GUI::PropertyEditors::ToggleButton (res->usable);
    proptable->add (_("_Usable:"), *manage (control),
		    _("Non-usable widgets are not rendered by default"));

    /* Separator */
    proptable->add_separator ();

    /* Position */
    WidgetProperties::add_position_controls (res, *proptable);

    /* Width */
    control = new GUI::PropertyEditors::WidthEntry (res->width);
    control = new GUI::PropertyEditors::AutoToggle (*manage (control), res->manual_width);
    proptable->add (_("_Width:"), *manage (control),
		    _("Horizontal size of the widget "
		      "(check to set manually)"));

    // FIXME: Add uline accelerators to the tabs
    notebook->pages ().push_back (
	Gtk::Notebook_Helpers::TabElem (*manage (proptable),
					_("General")));

    /* Page 2: Item list */
    notebook->pages ().push_back (
	Gtk::Notebook_Helpers::TabElem (*manage (new GUI::PropertyEditors::StringList (res->items)),
					_("Items")));
    
    notebook->show_all ();
    
    property_editor = notebook;
}

ListProperties::~ListProperties ()
{
    delete property_editor;
}

Gtk::Widget* ListProperties::get_editor ()
{
    return property_editor;
}
