//$Id: gadget.cc,v 1.3 2001/11/06 12:54:54 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include "gadget.h"
#include "gadget-canvas.h"

#include <gnome-xml/xmlmemory.h>

using Guikachu::Widgets::Gadget;
using namespace Guikachu::GUI::FormEditor;

Gadget::Gadget (Resources::Form   *owner,
		const std::string &id):
    Widget (owner, id),
    editor (0),
    usable (changed, true),
    width  (changed, 20),
    height (changed, 20)
{
}

Gadget::~Gadget ()
{
    if (editor)
	delete editor;
}

Gtk::Widget *Gadget::create_editor ()
{
    if (!editor)
	editor = new GadgetProperties (this);
    
    return editor->get_editor ();
}

CanvasItem* Gadget::create_canvas_item (GUI::FormEditor::Form *form)
{
    return new GadgetCanvasItem (this, form);
}

bool Gadget::load (StorageNode &node)
{
    usable = false;
    width = 0;
    height = 0;
    
    for (StorageNode curr_node  = node.children ();
	 curr_node; curr_node++)
    {
	if (curr_node.name () == "pos")
	{
	    x = curr_node.get_prop<int> ("x");
	    y = curr_node.get_prop<int> ("y");
	    width = curr_node.get_prop<int> ("width");
	    height = curr_node.get_prop<int> ("height");
	}
	else if (curr_node.name () == "usable")
	    usable = true;
	else
	    g_warning ("Error parsing `gadget' widget: "
		       "unexpected element `%s'",
		       curr_node.name ().c_str ());
    }

    changed ();

    return true;
}

void Gadget::save (StorageNode &node) const
{
    StorageNode my_node;

    /* Position */
    my_node = node.add_node ("pos");
    my_node.set_prop ("x", x);
    my_node.set_prop ("y", y);
    my_node.set_prop ("width", width);
    my_node.set_prop ("height", height);

    /* Usable */
    if (usable)
	node.add_node ("usable");
}

void Gadget::save_rcp (std::ostream &ostr) const
{
    ostr << "  GADGET ID " << id;

    ostr << " AT (" << x << " " << y
	 << " " << width << " " << height <<")";

    if (usable)
	ostr << " USABLE";
    else
	ostr << " NONUSABLE";
	
    ostr << std::endl;
}

