//$Id: form.h,v 1.13 2001/12/21 17:20:18 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifndef GUIKACHU_FORM_EDITOR_FORM_H
#define GUIKACHU_FORM_EDITOR_FORM_H

namespace Guikachu
{
    namespace GUI
    {
	namespace FormEditor
	{
	    class Form;
	}
    }
}

#include "form-res.h"
#include "form-win.h"
#include "form-prop.h"

#include <string>
#include <gnome--/canvas-group.h>
#include <gtk--/menu.h>
#include <sigc++/object.h>

namespace Guikachu
{
    namespace GUI
    {
	namespace FormEditor
	{
	    class Form: public SigC::Object
	    {		
		Resources::Form *res;
		GUI::FormWindow *win;
		FormProperties   editor;

		struct
		{
		    bool dragging;
		    bool drag_occured;

		    double last_x, last_y;
		    double offset_x, offset_y;
		    double delta_remainder_x, delta_remainder_y;
		} drag_context;
		
		Gnome::CanvasGroup *group;
		Gnome::CanvasItem  *background_item;
		Gnome::CanvasGroup *frame_group;
		Gnome::CanvasGroup *title_group;
		Gnome::CanvasGroup *widget_group;
		Gnome::CanvasItem  *bounding_box;

		Gtk::Menu           popup_menu;

	    public:
		Form (Resources::Form *res,
		      GUI::FormWindow *win);
		~Form ();
		Gtk::Widget *get_editor ();
		void update ();
		
		Gnome::CanvasGroup *get_canvas () const;
		
		SigC::Signal0<void>       clicked;
		SigC::Signal1<void, bool> selected;
		
	    private:
		/* Drawing methods */
		void draw_background ();
		void draw_frame ();
		void draw_title ();
		
		void draw_frame_modal    ();
		void draw_frame_nonmodal ();
		void draw_title_modal    ();
		void draw_title_nonmodal ();
		
		/* Callbacks */
		int  canvas_event_cb (GdkEvent *e);
		void selected_cb     (bool selected);

		/* Drag handlers */
		void drag_begin_impl  (GdkEvent *event);
		void drag_motion_impl (GdkEvent *event);
		void drag_end_impl    (GdkEvent *event);
	    };
	}
    }
}

#endif /* !GUIKACHU_FORM_EDITOR_FORM_H */
