//$Id: button-prop.cc,v 1.17 2001/12/09 18:55:58 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include "button-prop.h"

#include "config.h"
#include <libgnome/libgnome.h>

#include "widgets/num-entry.h"
#include "widgets/togglebutton.h"
#include "widgets/propertytable.h"
#include <gtk--/menu.h>

#include "widget-prop.h"
#include "resizeable-prop.h"
#include "textual-prop.h"

using namespace Guikachu::GUI::FormEditor;
using namespace Guikachu::Widgets;

ButtonProperties::ButtonProperties (Button *res_):
    res (res_),
    update_block (false)
{
    using namespace Gtk;
    using namespace SigC;

    GUI::PropertyTable *proptable = new GUI::PropertyTable ();
    Gtk::Widget *control;

    /* Resource ID */
    WidgetProperties::add_general_controls (res, *proptable);

    /* Label */
    TextualProperties::add_controls (res, *proptable);
    
    /* Frame type */
    frame_combo = new Gtk::OptionMenu ();
    /* Fill the frame type dropdown list */
    Menu *frame_menu = new Menu ();

#define FRAME_TYPE(s,t) 						 \
	    frame_menu->items ().push_back (				 \
		Menu_Helpers::MenuElem (				 \
		    s,							 \
		    bind (slot (this, &ButtonProperties::frame_menu_cb), \
			  Widgets::t)));

    FRAME_TYPE (_("None"),   BUTTON_FRAME_NONE);
    FRAME_TYPE (_("Simple"), BUTTON_FRAME_SIMPLE);
    FRAME_TYPE (_("Bold"),   BUTTON_FRAME_BOLD);
    
#undef FRAME_TYPE

    frame_menu->show_all ();
    frame_combo->set_menu (*manage (frame_menu));
    proptable->add (_("_Frame type:"), *manage (frame_combo));
    
    /* Repeat */
    control = new GUI::PropertyEditors::ToggleButton (res->repeat);
    proptable->add (_("_Repeating:"), *manage (control),
		    _("Repeating buttons fire multiple ButtonPress "
		      "signals when kept pressed"));

    /* Usable */
    control = new GUI::PropertyEditors::ToggleButton (res->usable);
    proptable->add (_("_Usable:"), *manage (control),
		    _("Non-usable widgets are not rendered by default"));

    /* Anchor right */
    control = new GUI::PropertyEditors::ToggleButton (res->anchor_right);
    proptable->add (_("_Anchor right:"), *manage (control),
		    _("Keep right aligned when changing label "
		      "text at run-time"));
    
    /* Separator */
    proptable->add_separator ();

    /* Position */
    WidgetProperties::add_position_controls (res, *proptable);
    
    /* Size */
    ResizeableProperties::add_controls (res, *proptable);
    
    proptable->show ();
    property_editor = proptable;

    res->changed.connect (slot (this, &ButtonProperties::update));
    update ();
}

ButtonProperties::~ButtonProperties ()
{
    delete property_editor;
}

void ButtonProperties::update ()
{
    update_block = true;
    
    frame_combo->set_history (res->frame);

    update_block = false;
}

Gtk::Widget* ButtonProperties::get_editor ()
{
    return property_editor;
}

void ButtonProperties::frame_menu_cb (Widgets::ButtonFrameType frame_type)
{
    res->frame = frame_type;
}
