//$Id: text.h,v 1.3 2001/12/09 18:56:03 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifndef GUIKACHU_WIDGETS_TEXT_H
#define GUIKACHU_WIDGETS_TEXT_H

#include <gtk--/text.h>
#include "property.h"
#include "property-editor.h"

namespace Guikachu
{
    namespace GUI
    {
	namespace PropertyEditors
	{
	    class TextArea: public PropertyEditor,
			    public Gtk::Text
	    {
		Property<std::string> &text;
		
	    public:
		TextArea (Property<std::string> &text);
		
		LabelAlignment   get_label_alignment () { return LABEL_ALIGN_TOP; };
		bool             get_resizeable      () { return true; };
	    private:
		bool update_block;
		void update ();
		
		void changed_cb ();
	    };
	}
    }
}

#endif /* !GUIKACHU_WIDGETS_TEXTAREA_H */
