//$Id: resource-combo.h,v 1.6 2001/12/09 18:56:03 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifndef GUIKACHU_WIDGETS_RESOURCE_COMBO_H
#define GUIKACHU_WIDGETS_RESOURCE_COMBO_H

namespace Guikachu
{
    namespace GUI
    {
	class ResourceCombo;
    }
}

#include <gtk--/box.h>
#include <gtk--/combo.h>
#include <gtk--/button.h>
#include "resource.h"
#include "resource-ref.h"
#include "property-editor.h"

namespace Guikachu
{
    namespace GUI
    {
	namespace PropertyEditors
	{
	    class ResourceCombo: public PropertyEditor,
				 public Gtk::HBox
	    {
		Gtk::Combo combo;
		Gtk::Button button_edit;
		
		Resources::Type type;
		
		Properties::ResourceRef &property;
	    public:
		ResourceCombo (Resources::Type          type,
			       Properties::ResourceRef &property);
	    private:
		bool update_block;
		void update ();
		
		void add_resource (Resources::Resource *res);
		void remove_resource (Resources::Resource *res);
		void resource_changed_cb (Resources::Resource *res);
		
		void edit_cb ();
		void entry_cb ();
	    };
	}
    }
}

#endif /* !GUIKACHU_WIDGETS_RESOURCE_COMBO_H */
