//$Id: num-entry.cc,v 1.4 2001/12/09 18:56:03 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include "num-entry.h"

#include <gtk--/adjustment.h>

using namespace Guikachu::GUI::PropertyEditors;

NumEntry::NumEntry (int min, int max,
		    Property<int> &property_):
    PropertyEditor (this),
    property (property_),
    update_block (false)
{
    using namespace SigC;
    
    Gtk::Adjustment *adj = new Gtk::Adjustment (min, min, max);
    adj->value_changed.connect (slot (this, &NumEntry::changed_cb));
    set_adjustment (*manage (adj));
    
    set_update_policy (GTK_UPDATE_IF_VALID);
    set_digits (0);

    property.changed.connect (slot (this, &NumEntry::update));
    update ();
}

void NumEntry::set_min (int min)
{
    get_adjustment ()->set_lower (min);
}

void NumEntry::set_max (int max)
{
    get_adjustment ()->set_upper (max);
}

void NumEntry::update ()
{
    update_block = true;

    set_value (property);
    
    update_block = false;
}

void NumEntry::changed_cb ()
{
    if (!update_block)
	property = get_value_as_int ();
}
