//$Id: scrollbar-prop.cc,v 1.8 2001/12/09 18:55:58 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include "scrollbar-prop.h"

#include "config.h"
#include <libgnome/libgnome.h>

#include "widget-prop.h"

#include "widgets/entry.h"
#include "widgets/togglebutton.h"
#include "widgets/propertytable.h"
#include "widgets/size-entry.h"
#include "widgets/auto-toggle.h"

using namespace Guikachu::GUI::FormEditor;
using namespace Guikachu::Widgets;

ScrollBarProperties::ScrollBarProperties (ScrollBar *res_):
    res (res_)
{
    using namespace Gtk;
    using namespace SigC;

    GUI::PropertyTable *proptable = new GUI::PropertyTable ();
    Gtk::Widget *control;
    
    /* Resource ID */
    WidgetProperties::add_general_controls (res, *proptable);

    /* Current value */
    control = value = new GUI::PropertyEditors::NumEntry (0, 32767, res->value);
    proptable->add (_("_Value:"), *manage (control),
		    _("Default value of scrollbar"));

    /* Max and min value */
    control = min_value = new GUI::PropertyEditors::NumEntry (0, 32767, res->min_value);
    proptable->add (_("Mi_nimum:"), *manage (control),
		    _("Minimum value allowed"));

    control = max_value = new GUI::PropertyEditors::NumEntry (0, 32767, res->max_value);
    proptable->add (_("Ma_ximum:"), *manage (control),
		    _("Maximum value allowed"));    

    /* Page size */
    control = new GUI::PropertyEditors::NumEntry (0, 32767, res->page_size);
    proptable->add (_("_Page size:"), *manage (control),
		    _("The amount of slider movement when the "
		      "scrollbar itself is clicked by the user"));
    
    /* Usable */
    control = new GUI::PropertyEditors::ToggleButton (res->usable);
    proptable->add (_("_Usable:"), *manage (control),
		    _("Non-usable widgets are not rendered by default"));

    /* Separator */
    proptable->add_separator ();

    /* Position */
    WidgetProperties::add_position_controls (res, *proptable);
    
    /* Size */
    /* Width */
    control = new GUI::PropertyEditors::SizeEntry (res->width);
    control = new GUI::PropertyEditors::AutoToggle (*manage (control), res->manual_width);
    proptable->add (_("_Width:"), *manage (control),
		    _("Horizontal size of the widget "
		      "(check to set manually)"));

    /* Height */
    control = new GUI::PropertyEditors::SizeEntry (res->height);
    proptable->add (_("_Height:"), *manage (control),
		    _("Vertical size of the widget"));
    
    proptable->show ();
    property_editor = proptable;

    res->changed.connect (SigC::slot (this, &ScrollBarProperties::update));
}

ScrollBarProperties::~ScrollBarProperties ()
{
    delete property_editor;
}

Gtk::Widget* ScrollBarProperties::get_editor ()
{
    return property_editor;
}

void ScrollBarProperties::update ()
{
    value->set_min (res->min_value);
    value->set_max (res->max_value);
}
