//$Id: dialog-res.cc,v 1.18 2001/12/09 15:23:02 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include "dialog-res.h"
#include "dialog-win.h"

using namespace Guikachu;
using std::string;
using std::vector;
using std::ostream;

Resources::Dialog::Dialog (const string& id):
    Resource (id),
    gui (0),
    title (changed, ""),
    text (changed, ""),
    dialog_type (changed, DIALOG_INFORMATION),
    buttons (changed, vector<string>()),
    default_button (changed, 0),
    help_id (changed, "")
{
}

Resources::Dialog::~Dialog ()
{
    delete gui;
}

void Resources::Dialog::show_ui ()
{
    if (!gui)
	gui = new GUI::DialogWindow (this);

    gui->show ();
}

bool Resources::Dialog::load (StorageNode &node)
{
    StorageNode curr_node;
    
    for (curr_node  = node.children ();
	 curr_node; curr_node++)
    {
	if (curr_node.name () == "text")
	    text = curr_node.get_content ();
	else if (curr_node.name () == "title")
	    title = curr_node.get_content ();
	else if (curr_node.name () == "help")
	    help_id = curr_node.get_prop<string> ("id");
	else if (curr_node.name () == "type")
	{
	    const string &xml_type = curr_node.get_prop<string> ("value");
	    
	    if (xml_type == "information")
		dialog_type = DIALOG_INFORMATION;
	    else if (xml_type == "confirmation")
		dialog_type = DIALOG_CONFIRMATION;
	    else if (xml_type == "warning")
		dialog_type = DIALOG_WARNING;
	    else if (xml_type == "error")
		dialog_type = DIALOG_ERROR;
	}
	else if (curr_node.name () == "buttons")
	{
	    /* Set default button */
	    default_button = curr_node.get_prop<int> ("default");
	    
	    /* Iterate buttons */
	    StorageNode button_node;
	    vector<string> button_vec;
	    
	    for (button_node = curr_node.children ();
		 button_node; button_node++)
	    {
		if (button_node.name () == "button")
		    button_vec.push_back (
			button_node.get_prop<string> ("label"));
		else
		    g_warning ("Error parsing `dialog' resource: "
			       "unexpected element `%s/%s'",
			       curr_node.name ().c_str (),
			       button_node.name ().c_str ());
	    }
	    
	    buttons = button_vec;
	}	    
	else
	    g_warning ("Error parsing `dialog' resource: "
		       "unexpected element `%s'",
		       curr_node.name ().c_str ());

    }

    changed ();
    
    return true;
}

void Resources::Dialog::save (StorageNode &node) const
{
    StorageNode my_node;
    string type_str;

    /* Dialog type */
    switch (dialog_type)
    {
    case DIALOG_INFORMATION:
	type_str = "information";
	break;
    case DIALOG_CONFIRMATION:
	type_str = "confirmation";
	break;
    case DIALOG_WARNING:
	type_str = "warning";
	break;
    case DIALOG_ERROR:
	type_str = "error";
    }

    my_node = node.add_node ("type");
    my_node.set_prop ("value", type_str);

    /* Title */
    node.add_node ("title", title);
    /* Text */
    node.add_node ("text", text);

    /* Help ID */
    if (help_id != "")
    {
	my_node = node.add_node ("help");
	my_node.set_prop ("id", help_id);
    }

    /* Buttons */
    const vector<string> &button_vec = buttons;
    if (button_vec.size ())
    {
	my_node = node.add_node ("buttons");
	my_node.set_prop ("default", default_button);
	
	StorageNode button_node;

	for (vector <string>::const_iterator i = button_vec.begin ();
	     i != button_vec.end (); i++)
	{
	    button_node = my_node.add_node ("button");
	    button_node.set_prop ("label", *i);
	}
    }
}

void Resources::Dialog::save_rcp (ostream &ostr) const
{
    ostr << "ALERT ID " << id << std::endl;
    
    switch (dialog_type)
    {
    case DIALOG_INFORMATION:
	ostr << "INFORMATION" << std::endl;
	break;
    case DIALOG_CONFIRMATION:
	ostr << "CONFIRMATION" << std::endl;
	break;
    case DIALOG_WARNING:
	ostr << "WARNING" << std::endl;
	break;
    case DIALOG_ERROR:
	ostr << "ERROR" << std::endl;
	break;
    }
    
    if (help_id != "")
	ostr << "  HELPID " << help_id << std::endl;

    ostr << "BEGIN" << std::endl;

    ostr << "  TITLE \"" << title << "\"" << std::endl
	 << "  MESSAGE \"" << text << "\"" << std::endl;
    if (buttons ().size ())
    {
	ostr << "  BUTTONS ";

	const vector<string> &buttons_vec = buttons;
	for (vector <string>::const_iterator i = buttons_vec.begin ();
	     i !=  buttons_vec.end (); i++)
	    ostr << "\"" << *i << "\" ";
	
	ostr << std::endl;
    }
    
    ostr << "END" << std::endl
	 << std::endl;
}
