//$Id: app-win.cc,v 1.9 2001/12/09 18:55:55 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include "app-win.h"

#include "config.h"
#include <libgnome/libgnome.h>

#ifdef GUIKACHU_USE_WM_ICONS
#include <libgnomeui/gnome-window-icon.h>
#endif

#include "widgets/propertytable.h"
#include "widgets/entry.h"

using namespace Guikachu;

GUI::AppWindow::AppWindow (Resources::Application *res_):
    res (res_)
{
    using namespace SigC;
    
    window = new Gtk::Window (GTK_WINDOW_DIALOG);
    window->set_policy (false, true, false);
    window->delete_event.connect (SigC::slot (this, &AppWindow::delete_event_impl));

#ifdef GUIKACHU_USE_WM_ICONS
    gnome_window_icon_set_from_file (window->gtkobj (), GNOME_ICONDIR "/guikachu.png");
#endif    

    GUI::PropertyTable *proptable = new GUI::PropertyTable ();
    Gtk::Entry *control;
    
    /* Icon caption */
    control = new GUI::PropertyEditors::Entry (false, res->iconname);
    proptable->add (_("Icon _caption:"), *manage (control));

    /* Version */
    control = new GUI::PropertyEditors::Entry (false, res->version);
    proptable->add (_("_Version:"), *manage (control));

    /* Vendor ID */
    control = new GUI::PropertyEditors::Entry (false, res->vendor);
    control->set_max_length (4);
    proptable->add (_("Vendor _ID:"), *manage (control));

    proptable->show_all ();
    window->add (*manage (proptable));

    res->changed.connect (slot (this, &AppWindow::update));
    update ();
}

GUI::AppWindow::~AppWindow ()
{
    delete window;
}

int GUI::AppWindow::delete_event_impl (GdkEventAny *e)
{
    window->hide ();
    return true;
}

void GUI::AppWindow::show ()
{
    window->show_all ();
    window->get_window ().raise ();
}

void GUI::AppWindow::update ()
{
    gchar *title_buf = g_strdup_printf (_("Application: %s"), res->iconname ().c_str ());
    window->set_title (title_buf);
    g_free (title_buf);
}
