//$Id: table.cc,v 1.10 2001/11/15 23:25:05 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include "table.h"
#include "table-canvas.h"

#include "form-editor.h"

using Guikachu::Widgets::Table;
using namespace Guikachu::GUI::FormEditor;

Table::Table (Resources::Form   *owner,
	      const std::string &id):
    Widget       (owner, id),
    editor       (0),
    num_rows     (changed, 1),
    num_columns  (changed, 1),
    column_width (changed, std::vector<int>(1, 1))
{
    changed.connect (SigC::slot (this, &Table::update));
}

Table::~Table ()
{
    if (editor)
	delete editor;
}

Gtk::Widget *Table::create_editor ()
{
    if (!editor)
	editor = new TableProperties (this);
    
    return editor->get_editor ();
}

CanvasItem* Table::create_canvas_item (GUI::FormEditor::Form *form)
{
    return new TableCanvasItem (this, form);
}

bool Table::load (StorageNode &node)
{
    column_width = std::vector<int>(0);
    num_columns  = 0;
    
    for (StorageNode curr_node  = node.children ();
	 curr_node; curr_node++)
    {
	if (curr_node.name () == "pos")
	{
	    x = curr_node.get_prop<int> ("x");
	    y = curr_node.get_prop<int> ("y");
	}
	else if (curr_node.name () == "table_data")
	{
	    num_rows = curr_node.get_prop<int> ("rows");
	    
	    /* iterate over column fields */
	    std::vector<int> columns;
	    StorageNode column_node;
	    for (column_node = curr_node.children ();
		 column_node; column_node++)
	    {
		if (column_node.name () == "column")
		    columns.push_back (column_node.get_prop<int> ("width"));
		else
		    g_warning ("Error parsing `table' resource: "
			       "unexpected element `%s/%s'",
			       curr_node.name ().c_str (),
			       column_node.name ().c_str ());
	    }
	    column_width = columns;
	    num_columns = columns.size ();
	}
	else
	    g_warning ("Error parsing `table' widget: "
		       "unexpected element `%s'",
		       curr_node.name ().c_str ());
    }

    changed ();

    return true;
}

void Table::save (StorageNode &node) const
{
    StorageNode my_node;

    /* Position */
    my_node = node.add_node ("pos");
    my_node.set_prop ("x", x);
    my_node.set_prop ("y", y);

    my_node = node.add_node ("table_data");

    /* Number of rows and columns */
    my_node.set_prop ("rows", num_rows);

    std::vector<int> columns = column_width;
    for (int i = 0; i < num_columns; i++)
	my_node.add_node ("column").set_prop ("width", columns[i]);
}

void Table::save_rcp (std::ostream &ostr) const
{   
    ostr << "  TABLE ID " << id;
    ostr << " AT (" << x << " " << y << " AUTO AUTO)";
    ostr << " ROWS "   << num_rows;

    std::vector<int> columns = column_width;
    ostr << " COLUMNS " << num_columns;
    ostr << " COLUMNWIDTHS ";
    for (int i = 0; i < num_columns; i++)
	ostr << columns[i] << " ";
	
    ostr << std::endl;
}

void Table::update ()
{
    /* Make sure column_width contains at least num_columns elements */
    
    const std::vector<int> &columns = column_width;
    
    int num_columns_in_vec = columns.size ();
    int num_columns_target = num_columns;

    if (num_columns_in_vec < num_columns_target)
    {
	std::vector<int> columns_copy = columns;
	
	for (int i = num_columns_in_vec; i < num_columns_target; i++)
	    columns_copy.push_back (1);
	
	column_width = columns_copy;
    }
}
