<?xml version="1.0"?> <!-- -*- xml -*- -->
<xsl:stylesheet version="1.0"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
  
  <xsl:template match="section/resource" mode="linkto">
    <xsl:variable name="parent-uri">
      <xsl:apply-templates select=".." mode="uri"/>
    </xsl:variable>
    <a href="{$parent-uri}#res-{@name}"><xsl:value-of select="title/text()"/></a>    
  </xsl:template>

  <xsl:template match="guikachu-doc/section" mode="linkto">
    <xsl:variable name="uri">
      <xsl:apply-templates select="." mode="uri"/>
    </xsl:variable>
    <a href="{$uri}"><xsl:value-of select="title/text()"/></a>    
  </xsl:template>
  
  <xsl:template match="guikachu-doc/section[1]" mode="linkto">
    <a href="#sec-{@id}"><xsl:value-of select="title/text()"/></a>    
  </xsl:template>
  
  <xsl:template match="section/section" mode="linkto">
    <xsl:variable name="parent-uri">
      <xsl:apply-templates select=".." mode="uri"/>
    </xsl:variable>
    <xsl:message><xsl:text>inside section/section</xsl:text></xsl:message>
    <a href="{$parent-uri}#sec-{@id}"><xsl:value-of select="title/text()"/></a>    
  </xsl:template>

  <xsl:template match="section|resource" mode="toc">
    <dt>
      <xsl:apply-templates select="." mode="linkto"/>
      <xsl:if test="resource">
	<dd>
	  <dl>
	    <xsl:apply-templates select="resource|section" mode="toc"/>
	  </dl>
	</dd>
      </xsl:if>
    </dt>
  </xsl:template>
  
</xsl:stylesheet>
