//$Id: mainwin-io.cc,v 1.12 2001/11/14 15:10:36 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include "mainwin.h"

#include "resource-manager.h"
#include "session.h"
#include <gnome--/main.h>
#include <gnome--/messagebox.h>

using namespace Guikachu;
using std::string;

bool GUI::MainWin::check_save ()
{
    if (!ResourceManager::is_dirty ())
    {
	if (in_exit)
	    Gnome::Main::quit ();
	return true;
    }
    
    char *message;
    int response;
    
    if (filename != "")
	message = g_strdup_printf (
	    "%s has changed since last saved.\n"
	    "Would you like to save it?", g_basename (filename.c_str ()));
    else
	message = g_strdup (
	    "The current file is unsaved.\n"
	    "Would you like to save it?");

    Gnome::Dialog *dialog = new Gnome::MessageBox (
	message, GNOME_MESSAGE_BOX_QUESTION, std::vector<string>());
    dialog->append_button (_("Save"), GNOME_STOCK_PIXMAP_SAVE);
    dialog->append_button (_("Discard"), GNOME_STOCK_PIXMAP_TRASH);
    dialog->append_button (GNOME_STOCK_BUTTON_CANCEL);

    dialog->set_modal (true);
    dialog->set_default (0);
    gnome_dialog_grab_focus (dialog->gtkobj (), 0);
    
    response = dialog->run_and_close ();

    if (response == 2 ||
	response == -1) // Cancel
	return false;

    if (response == 1) // No
	if (in_exit)
	    Gnome::Main::quit ();
    
    if (response == 0) // Yes
    {
	save_cb ();
	if (ResourceManager::is_dirty ())
	    return check_save ();
    }
	    
    return true;
}

void GUI::MainWin::new_cb ()
{
    // Check if file has changed
    if (!check_save ())
	return;

    ResourceManager::reset ();
    filename = "";
    Guikachu::Main::instance ()->set_filename (filename);

    update_title ();
}

void GUI::MainWin::set_filename (const string& filename_)
{
    filename = filename_;
    update_title ();
}

void GUI::MainWin::filesel_close_cb (Gtk::FileSelection *fs)
{
    delete fs;
    Gtk::Main::quit ();
}

void GUI::MainWin::save_cb ()
{
    if (filename == "")
	save_as_cb ();
    else
    {
	ResourceManager::save (filename);
	if (in_exit)
	    Gnome::Main::quit ();
    }
}

void GUI::MainWin::save_as_cb ()
{
    Gtk::FileSelection *fs = new Gtk::FileSelection ();

    fs->show_fileop_buttons ();
    fs->set_title (_("Save Guikachu file"));

    fs->get_ok_button ()->clicked.connect (SigC::bind (
	SigC::slot (this, &GUI::MainWin::filesel_save_cb), fs));
    fs->get_cancel_button ()->clicked.connect (SigC::bind (
	SigC::slot (this, &GUI::MainWin::filesel_close_cb), fs));

    fs->set_transient_for (*this);
    fs->set_modal (true);
    fs->show ();
    Gtk::Main::run ();
}

void GUI::MainWin::load_cb ()
{
    // Check if file has changed
    if (!check_save ())
	return;
    
    // Set up a file dialog and show it    
    Gtk::FileSelection *fs = new Gtk::FileSelection ();

    fs->hide_fileop_buttons ();
    fs->set_title (_("Select Guikachu file to open"));

    fs->get_ok_button ()->clicked.connect (SigC::bind (
	SigC::slot (this, &GUI::MainWin::filesel_open_cb), fs));
    fs->get_cancel_button ()->clicked.connect (SigC::bind (
	SigC::slot (this, &GUI::MainWin::filesel_close_cb), fs));

    fs->set_transient_for (*this);
    fs->set_modal (true);
    fs->show ();
    Gtk::Main::run ();
}

void GUI::MainWin::export_cb ()
{
    Gtk::FileSelection *fs = new Gtk::FileSelection ();

    fs->show_fileop_buttons ();
    fs->set_title (_("Export to RCP"));
    
    fs->get_ok_button ()->clicked.connect (SigC::bind (
	SigC::slot (this, &GUI::MainWin::filesel_export_cb), fs));
    fs->get_cancel_button ()->clicked.connect (SigC::bind (
	SigC::slot (this, &GUI::MainWin::filesel_close_cb), fs));

    fs->set_transient_for (*this);
    fs->set_modal (true);
    fs->show ();
}


/*********************************
 * File I/O dialog callbacks
 *********************************/
void GUI::MainWin::filesel_save_cb (Gtk::FileSelection *fs)
{
    filename = fs->get_filename ();
    filesel_close_cb (fs);
    Guikachu::Main::instance ()->set_filename (filename);

    update_title ();
    save_cb ();

    if (in_exit)
	Gnome::Main::quit ();
}

void GUI::MainWin::filesel_open_cb (Gtk::FileSelection *fs)
{
    string new_filename = fs->get_filename ();
    filesel_close_cb (fs);

    ResourceManager::IOResult result = ResourceManager::load (new_filename);

    gchar *buffer;
    switch (result)
    {
    case ResourceManager::IO_OK:
	filename = new_filename;
	Guikachu::Main::instance ()->set_filename (filename);
	update_title ();
	break;
    case ResourceManager::IO_NOTFOUND:
	buffer = g_strdup_printf (_("Unable to open `%s'"),
				  g_basename (new_filename.c_str ()));
	GUI::show_error (buffer);
	g_free (buffer);
	break;
    case ResourceManager::IO_INVALID:
	buffer = g_strdup_printf (_("Unable to open `%s': "
				    "Not a valid Guikachu document"),
				  g_basename (new_filename.c_str ()));
	GUI::show_error (buffer);
	g_free (buffer);
	break;
    }
}

void GUI::MainWin::filesel_export_cb (Gtk::FileSelection *fs)
{
    string filename = fs->get_filename ();
    filesel_close_cb (fs);
    
    ResourceManager::export_rcp (filename);
}

int GUI::MainWin::delete_event_impl (GdkEventAny *e)
{
    in_exit = true;

    if (!check_save ())
	in_exit = false;

    return true;
}
