//$Id: text-field.cc,v 1.6 2001/11/15 20:22:00 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include "text-field.h"
#include "text-field-canvas.h"

#include "form-editor.h"

using Guikachu::Widgets::TextField;
using namespace Guikachu::GUI::FormEditor;

TextField::TextField (Resources::Form   *owner,
		      const std::string &id):
    Widget (owner, id),
    Resizeable (changed),
    editor (0),
    
    usable (changed, true),

    font (changed, 0),
    editable (changed, true),
    multi_line (changed, false),
    auto_shift (changed, false),
    max_length (changed, 0),
    numeric (changed, false),
    
    underline (changed, true),
    dynamic_size (changed, false),
    justify_right (changed, false),
    has_scrollbar (changed, false)
{
}

TextField::~TextField ()
{
    if (editor)
	delete editor;
}

Gtk::Widget* TextField::create_editor ()
{
    if (!editor)
	editor = new TextFieldProperties (this);
    
    return editor->get_editor ();
}

CanvasItem* TextField::create_canvas_item (GUI::FormEditor::Form *form)
{
    return new TextFieldCanvasItem (this, form);
}

bool TextField::load (StorageNode &node)
{
    /* Non-NULL default values */
    usable = false;
    editable = false;
    underline = false;
    
    for (StorageNode curr_node  = node.children ();
	 curr_node; curr_node++)
    {
	if (curr_node.name () == "pos")
	{
	    x = curr_node.get_prop<int> ("x");
	    y = curr_node.get_prop<int> ("y");

	    std::string width_str = curr_node.get_prop<std::string> ("width");
	    if (width_str == "auto")
	    {
		manual_width = false;
		width = 0;
	    } else {
		manual_width = true;
		width = atoi (width_str.c_str ());
	    }
	    
	    std::string height_str = curr_node.get_prop<std::string> ("height");
	    if (height_str == "auto")
	    {
		manual_height = false;
		height = 0;
	    } else {
		manual_height = true;
		height = atoi (height_str.c_str ());
	    }
	}
	else if (curr_node.name () == "text")
	{
	    font = curr_node.get_prop<int> ("font");
	    max_length = curr_node.get_prop<int> ("max_length");
	}
	else if (curr_node.name () == "usable")
	    usable = true;
	else if (curr_node.name () == "editable")
	    editable = true;
	else if (curr_node.name () == "multi_line")
	    multi_line = true;
	else if (curr_node.name () == "auto_shift")
	    auto_shift = true;
	else if (curr_node.name () == "numeric")
	    numeric = true;
	else if (curr_node.name () == "underline")
	    underline = true;
	else if (curr_node.name () == "dynamic_size")
	    dynamic_size = true;
	else if (curr_node.name () == "justify_right")
	    justify_right = true;
	else if (curr_node.name () == "has_scrollbar")
	    has_scrollbar = true;
	else
	    g_warning ("Error parsing `text_field' widget: "
		       "unexpected element `%s'",
		       curr_node.name ().c_str ());
	}

    changed ();

    return true;
}

void TextField::save (StorageNode &node) const
{
    StorageNode my_node;

    /* Position */
    my_node = node.add_node ("pos");
    my_node.set_prop ("x", x);
    my_node.set_prop ("y", y);

    /* Size */
    if (manual_width)
	my_node.set_prop ("width", width);
    else
	my_node.set_prop ("width", "auto");

    if (manual_height)
	my_node.set_prop ("height", height);
    else
	my_node.set_prop ("height", "auto");
    
    /* Flags */
    if (usable)
	node.add_node ("usable");
    if (editable)
	node.add_node ("editable");
    if (multi_line)
	node.add_node ("multi_line");
    if (auto_shift)
	node.add_node ("auto_shift");
    if (numeric)
	node.add_node ("numeric");

    if (underline)
	node.add_node ("underline");
    if (dynamic_size)
	node.add_node ("dynamic_size");
    if (justify_right)
	node.add_node ("justify_right");
    if (has_scrollbar)
	node.add_node ("has_scrollbar");

    /* Font and length */
    my_node = node.add_node ("text");
    my_node.set_prop ("font", font);
    my_node.set_prop ("max_length", max_length);
}

void TextField::save_rcp (std::ostream &ostr) const
{
    gchar *width_str, *height_str;

    width_str = g_strdup_printf ("%d", get_display_width ());
    
    if (manual_height)
	height_str = g_strdup_printf ("%d", height ());
    else
	height_str = g_strdup ("AUTO");
    
    g_free (height_str);
    g_free (width_str);

    ostr << "  FIELD ID " << id;
    ostr << " AT (" << x << " " << y << " " << width_str << " " << height_str << ")";

    ostr << " FONT " << font;
    
    if (usable)
	ostr << " USABLE";
    else
	ostr << " NONUSABLE";
    
    if (editable)
	ostr << " EDITABLE";
    else
	ostr << " NONEDITABLE";

    if (multi_line)
	ostr << " MULTIPLELINES";
    else
	ostr << " SINGLELINE";

    if (justify_right)
	ostr << " RIGHTALIGN";
    else
	ostr << " LEFTALIGN";

    if (underline)
	ostr << " UNDERLINED";

    if (dynamic_size)
	ostr << " DYNAMICSIZE";

    if (max_length)
	ostr << " MAXCHARS " << max_length;
    else
	ostr << " MAXCHARS 32767";

    if (auto_shift)
	ostr << " AUTOSHIFT";

    if (numeric)
	ostr << " NUMERIC";

    if (has_scrollbar)
	ostr << " HASSCROLLBAR";

    ostr << std::endl;
}

int TextField::get_auto_width () const
{
    return 30;
}

int TextField::get_display_height () const
{
    int min_height = get_auto_height ();
    
    if (manual_height && height > min_height)
	return height;
    
    return min_height;
}

int TextField::get_auto_height () const
{
    return get_font_height (font);
}
