//$Id: list-canvas.cc,v 1.14 2001/11/11 20:56:01 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include "list-canvas.h"

#include "form-editor.h"

#include <gnome--/canvas.h>
#include <gnome--/canvas-property.h>

using namespace Guikachu::GUI::FormEditor;

ListCanvasItem::ListCanvasItem (Widgets::List    *widget_,
				FormEditor::Form *form):
    CanvasItem (widget_, form),
    widget (widget_),
    group (0)
{
    update ();
}

void ListCanvasItem::update ()
{
    if (group)
	delete group;
    
    group = new Gnome::CanvasGroup (*(form->get_canvas ()), 0, 0);

    int font_num = widget->font;    
    int height = get_font_height (font_num) * widget->visible_items;
    int width = widget->get_display_width ();
    bool usable = widget->usable;

    /* Render text items */
    const std::vector<std::string> &listitems = widget->items;

    // FIXME: size() is unsigned, visible_items is signed
    int num_items = listitems.size ();
    int visible_strings = MIN (widget->visible_items, num_items);
    
    int line_spacing = get_font_height (font_num);
    int text_y = widget->y;
    int text_x = widget->x + 2;
    
    for (int i = 0; i < visible_strings; i++)
    {
	draw_text (*group, listitems[i], font_num,
		   text_x, text_y, usable,
		   GTK_ANCHOR_NW,
		   width - 4);
	text_y += line_spacing;
    }

    /* Render frame */
    int x1 = widget->x - 1;
    int y1 = widget->y - 1;
    int x2 = x1 + width + 1;
    int y2 = y1 + height + 1;
    
    using namespace Gnome::CanvasHelpers;

    *(FormEditor::draw_rectangle (*group, x1, y1, x2, y2))
	<< width_units (1)
	<< outline_color (usable ? GUIKACHU_FGC : GUIKACHU_FGC_DISABLED);    

    set_canvas_item (group);
}
