<?xml version="1.0"?> <!-- -*- xml -*- -->
<xsl:stylesheet version="1.0"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

  <xsl:template match="section/resource" mode="linkto">
    <a href="{../@id}.html#res-{@name}"><xsl:value-of select="title/text()"/></a>    
  </xsl:template>

  <xsl:template match="section" mode="linkto">
    <a href="{@id}.html"><xsl:value-of select="title/text()"/></a>    
  </xsl:template>

  <xsl:template match="section[1]" mode="linkto">
    <a href="#sec-{@id}"><xsl:value-of select="title/text()"/></a>    
  </xsl:template>
  
  <xsl:template match="section" mode="toc">
    <dt>
      <xsl:apply-templates select="." mode="linkto"/>
      <xsl:if test="resource">
	<dd>
	  <dl>
	    <xsl:for-each select="resource">
	      <dt>
		<xsl:apply-templates select="." mode="linkto"/>
	      </dt>
	    </xsl:for-each>
	  </dl>
	</dd>
      </xsl:if>
    </dt>
  </xsl:template>
  
</xsl:stylesheet>
